/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.resources.streaming;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.confluent.ksql.api.server.MetricsCallbackHolder;
import io.confluent.ksql.rest.ApiJsonMapper;
import io.confluent.ksql.rest.server.resources.streaming.Flow;
import io.confluent.ksql.rest.server.resources.streaming.SessionUtil;
import io.confluent.ksql.rest.util.EntityUtil;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.vertx.core.http.ServerWebSocket;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class WebSocketSubscriber<T>
implements Flow.Subscriber<Collection<T>>,
AutoCloseable {
    private static final Logger log = LogManager.getLogger(WebSocketSubscriber.class);
    private final ServerWebSocket websocket;
    private Flow.Subscription subscription;
    private volatile boolean closed;
    private volatile boolean drainHandlerSet;
    private Optional<MetricsCallbackHolder> metricsCallbackHolderOptional = Optional.empty();
    private long startTimeNanos;

    WebSocketSubscriber(ServerWebSocket websocket) {
        this.websocket = websocket;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }

    public void onSubscribe(Flow.Subscription subscription, MetricsCallbackHolder metricsCallbackHolder, long startTimeNanos) {
        this.subscription = subscription;
        subscription.request(1L);
        this.metricsCallbackHolderOptional = Optional.of(metricsCallbackHolder);
        this.startTimeNanos = startTimeNanos;
    }

    @Override
    public void onNext(Collection<T> rows) {
        for (T row : rows) {
            if (this.closed) continue;
            try {
                String buffer = ApiJsonMapper.INSTANCE.get().writeValueAsString(row);
                this.websocket.writeTextMessage(buffer);
                if (!this.websocket.writeQueueFull()) continue;
                this.drainHandlerSet = true;
                this.websocket.drainHandler(v -> this.websocketDrained());
            }
            catch (JsonProcessingException e) {
                log.warn("Error serializing row to websocket", (Throwable)e);
            }
        }
        this.checkRequestTokens();
    }

    @Override
    public void onError(Throwable e) {
        log.error("error in websocket", e);
        String msg = e.getMessage() == null || e.getMessage().trim().isEmpty() ? "KSQL exception: " + e.getClass().getSimpleName() : e.getMessage();
        this.metricsCallbackHolderOptional.ifPresent(mc -> mc.reportMetrics(0, 0L, 0L, this.startTimeNanos));
        SessionUtil.closeSilently(this.websocket, WebSocketCloseStatus.INTERNAL_SERVER_ERROR.code(), msg);
    }

    @Override
    public void onComplete() {
        this.metricsCallbackHolderOptional.ifPresent(mc -> mc.reportMetrics(0, 0L, 0L, this.startTimeNanos));
        SessionUtil.closeSilently(this.websocket, WebSocketCloseStatus.NORMAL_CLOSURE.code(), "done");
    }

    @Override
    public void onSchema(LogicalSchema schema) {
        try {
            this.websocket.writeTextMessage(ApiJsonMapper.INSTANCE.get().writeValueAsString(EntityUtil.buildSourceSchemaEntity(schema)));
        }
        catch (IOException e) {
            log.error("Error sending schema", (Throwable)e);
            SessionUtil.closeSilently(this.websocket, WebSocketCloseStatus.PROTOCOL_ERROR.code(), "Unable to send schema");
        }
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.subscription != null) {
            this.subscription.cancel();
        }
    }

    private void checkRequestTokens() {
        if (!this.closed && !this.drainHandlerSet) {
            this.subscription.request(1L);
        }
    }

    private void websocketDrained() {
        this.drainHandlerSet = false;
        this.checkRequestTokens();
    }
}

