/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.restore;

import com.github.rvesse.airline.HelpOption;
import com.github.rvesse.airline.annotations.Arguments;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.restrictions.Required;
import io.confluent.ksql.rest.util.OptionsParser;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;

@Command(name="ksql-restore-command-topic", description="KSQL Restore Command Topic")
public class RestoreOptions {
    @Inject
    public HelpOption<?> help;
    @Required
    @Option(name={"--config-file"}, description="A file specifying configs for the KSQL Server, KSQL, and its underlying Kafka Streams instance(s). Refer to KSQL documentation for a list of available configs.")
    private String configFile;
    @Option(name={"--skip-incompatible-commands", "-s"}, description="This restore command can restore command topic commands that are of version (18) or lower. If true, the restore command will skip all incompatible commands. For each incompatible command, the restore process will check if it contains a queryId. If it's present, the restore process will attempt to clean up internal topics and state stores for the query.If false, the restore command will throw an exception when it encounters an incompatible command.")
    private boolean skipIncompatibleCommands = false;
    @Option(name={"--yes", "-y"}, description="Automatic \"yes\" as answer to prompt and run non-interactively.")
    private boolean automaticYes = false;
    @Required
    @Arguments(title={"backup-file"}, description="A file specifying the file that contains the metadata backup.")
    private String backupFile;

    public File getConfigFile() {
        return new File(this.configFile);
    }

    public File getBackupFile() {
        return new File(this.backupFile);
    }

    public boolean isAutomaticYes() {
        return this.automaticYes;
    }

    public boolean isSkipIncompatibleCommands() {
        return this.skipIncompatibleCommands;
    }

    public static RestoreOptions parse(String ... args) throws IOException {
        return OptionsParser.parse(args, RestoreOptions.class);
    }
}

