/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.services;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.reactive.BufferedPublisher;
import io.confluent.ksql.rest.client.KsqlClient;
import io.confluent.ksql.rest.client.KsqlTarget;
import io.confluent.ksql.rest.client.RestResponse;
import io.confluent.ksql.rest.entity.ClusterStatusResponse;
import io.confluent.ksql.rest.entity.KsqlEntityList;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.confluent.ksql.rest.entity.KsqlHostInfoEntity;
import io.confluent.ksql.rest.entity.LagReportingMessage;
import io.confluent.ksql.rest.entity.StreamedRow;
import io.confluent.ksql.rest.server.services.InternalKsqlClientFactory;
import io.confluent.ksql.services.SimpleKsqlClient;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlHostInfo;
import io.vertx.core.Vertx;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.WriteStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class DefaultKsqlClient
implements SimpleKsqlClient {
    private static final Logger LOG = LogManager.getLogger(DefaultKsqlClient.class);
    private final Optional<String> authHeader;
    private final KsqlClient sharedClient;
    private final boolean ownSharedClient;
    private final KsqlConfig ksqlConfig;

    @VisibleForTesting
    DefaultKsqlClient(Optional<String> authHeader, Map<String, Object> clientProps, BiFunction<Integer, String, SocketAddress> socketAddressFactory) {
        this(authHeader, InternalKsqlClientFactory.createInternalClient(DefaultKsqlClient.toClientProps(clientProps), socketAddressFactory, Vertx.vertx()), true, new KsqlConfig(clientProps));
    }

    DefaultKsqlClient(Optional<String> authHeader, KsqlClient sharedClient, KsqlConfig ksqlConfig) {
        this(authHeader, sharedClient, false, ksqlConfig);
    }

    DefaultKsqlClient(Optional<String> authHeader, KsqlClient sharedClient, boolean ownSharedClient, KsqlConfig ksqlConfig) {
        this.authHeader = Objects.requireNonNull(authHeader, "authHeader");
        this.sharedClient = Objects.requireNonNull(sharedClient, "sharedClient");
        this.ownSharedClient = ownSharedClient;
        this.ksqlConfig = ksqlConfig;
    }

    public RestResponse<KsqlEntityList> makeKsqlRequest(URI serverEndPoint, String sql, Map<String, ?> requestProperties) {
        KsqlTarget target = this.sharedClient.target(serverEndPoint);
        return this.getTarget(target).postKsqlRequest(sql, requestProperties, Optional.empty());
    }

    public RestResponse<List<StreamedRow>> makeQueryRequest(URI serverEndPoint, String sql, Map<String, ?> configOverrides, Map<String, ?> requestProperties) {
        KsqlTarget target = this.sharedClient.target(serverEndPoint).properties(configOverrides).timeout(this.getQueryTimeout(configOverrides));
        RestResponse resp = this.getTarget(target).postQueryRequest(sql, requestProperties, Optional.empty());
        if (resp.isErroneous()) {
            return RestResponse.erroneous((int)resp.getStatusCode(), (KsqlErrorMessage)resp.getErrorMessage());
        }
        return RestResponse.successful((int)resp.getStatusCode(), (Object)((List)resp.getResponse()));
    }

    public RestResponse<Integer> makeQueryRequest(URI serverEndPoint, String sql, Map<String, ?> configOverrides, Map<String, ?> requestProperties, WriteStream<List<StreamedRow>> rowConsumer, CompletableFuture<Void> shouldCloseConnection, Function<StreamedRow, StreamedRow> addHostInfo) {
        KsqlTarget target = this.sharedClient.target(serverEndPoint).properties(configOverrides).timeout(this.getQueryTimeout(configOverrides));
        RestResponse resp = this.getTarget(target).postQueryRequest(sql, requestProperties, Optional.empty(), rowConsumer, shouldCloseConnection, addHostInfo);
        if (resp.isErroneous()) {
            return RestResponse.erroneous((int)resp.getStatusCode(), (KsqlErrorMessage)resp.getErrorMessage());
        }
        return RestResponse.successful((int)resp.getStatusCode(), (Object)((Integer)resp.getResponse()));
    }

    public CompletableFuture<RestResponse<BufferedPublisher<StreamedRow>>> makeQueryRequestStreamed(URI serverEndPoint, String sql, Map<String, ?> configOverrides, Map<String, ?> requestProperties) {
        KsqlTarget target = this.sharedClient.targetHttp2(serverEndPoint).properties(configOverrides);
        CompletableFuture response = this.getTarget(target).postQueryRequestStreamedAsync(sql, requestProperties);
        return response.thenApply(resp -> {
            if (resp.isErroneous()) {
                return RestResponse.erroneous((int)resp.getStatusCode(), (KsqlErrorMessage)resp.getErrorMessage());
            }
            return RestResponse.successful((int)resp.getStatusCode(), (Object)((BufferedPublisher)resp.getResponse()));
        });
    }

    public void makeAsyncHeartbeatRequest(URI serverEndPoint, KsqlHostInfo host, long timestamp) {
        KsqlTarget target = this.sharedClient.target(serverEndPoint);
        this.getTarget(target).postAsyncHeartbeatRequest(new KsqlHostInfoEntity(host.host(), host.port()), timestamp).exceptionally(t -> {
            LOG.debug("Exception in async heartbeat request", t);
            return null;
        });
    }

    public RestResponse<ClusterStatusResponse> makeClusterStatusRequest(URI serverEndPoint) {
        KsqlTarget target = this.sharedClient.target(serverEndPoint);
        return this.getTarget(target).getClusterStatus();
    }

    public void makeAsyncLagReportRequest(URI serverEndPoint, LagReportingMessage lagReportingMessage) {
        KsqlTarget target = this.sharedClient.target(serverEndPoint);
        this.getTarget(target).postAsyncLagReportingRequest(lagReportingMessage).exceptionally(t -> {
            LOG.debug("Exception in async lag reporting request", t);
            return null;
        });
    }

    public void close() {
        if (this.ownSharedClient) {
            this.sharedClient.close();
        }
    }

    private KsqlTarget getTarget(KsqlTarget target) {
        return this.authHeader.map(arg_0 -> ((KsqlTarget)target).authorizationHeader(arg_0)).orElse(target);
    }

    private static Map<String, String> toClientProps(Map<String, Object> config) {
        HashMap<String, String> clientProps = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : config.entrySet()) {
            clientProps.put(entry.getKey(), entry.getValue().toString());
        }
        return clientProps;
    }

    private long getQueryTimeout(Map<String, ?> configOverrides) {
        if (configOverrides.containsKey("ksql.query.pull.forwarding.timeout.ms")) {
            return (Long)configOverrides.get("ksql.query.pull.forwarding.timeout.ms");
        }
        return this.ksqlConfig.getLong("ksql.query.pull.forwarding.timeout.ms");
    }
}

