/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.services;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.properties.LocalProperties;
import io.confluent.ksql.rest.client.KsqlClient;
import io.confluent.ksql.util.VertxSslOptionsFactory;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.SocketAddress;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class InternalKsqlClientFactory {
    private static final Logger LOG = LogManager.getLogger(InternalKsqlClientFactory.class);

    private InternalKsqlClientFactory() {
    }

    public static KsqlClient createInternalClient(Map<String, String> clientProps, BiFunction<Integer, String, SocketAddress> socketAddressFactory, Vertx vertx) {
        String internalClientAuth = clientProps.get("ksql.internal.ssl.client.authentication");
        boolean verifyHost = !Strings.isNullOrEmpty((String)internalClientAuth) && !"NONE".equals(internalClientAuth);
        return new KsqlClient(Optional.empty(), new LocalProperties((Map)ImmutableMap.of()), InternalKsqlClientFactory.httpOptionsFactory(clientProps, verifyHost, InternalKsqlClientFactory::createClientOptions), InternalKsqlClientFactory.httpOptionsFactory(clientProps, verifyHost, InternalKsqlClientFactory::createClientOptionsHttp2), socketAddressFactory, vertx);
    }

    private static Function<Boolean, HttpClientOptions> httpOptionsFactory(Map<String, String> clientProps, boolean verifyHost, BiFunction<Map<String, String>, Boolean, HttpClientOptions> clientOptions) {
        return tls -> {
            HttpClientOptions httpClientOptions = (HttpClientOptions)clientOptions.apply(clientProps, (Boolean)tls);
            if (!tls.booleanValue()) {
                return httpClientOptions;
            }
            httpClientOptions.setVerifyHost(verifyHost);
            httpClientOptions.setSsl(true);
            Optional trustStoreOptions = VertxSslOptionsFactory.getJksTrustStoreOptions((Map)clientProps);
            if (trustStoreOptions.isPresent()) {
                httpClientOptions.setTrustStoreOptions((JksOptions)trustStoreOptions.get());
                Optional keyStoreOptions = VertxSslOptionsFactory.buildJksKeyStoreOptions((Map)clientProps, Optional.ofNullable((String)clientProps.get("ksql.ssl.keystore.alias.internal")));
                keyStoreOptions.ifPresent(options -> httpClientOptions.setKeyStoreOptions(options));
            }
            return httpClientOptions;
        };
    }

    private static HttpClientOptions createClientOptions(Map<String, String> clientProps, boolean tls) {
        return new HttpClientOptions().setMaxPoolSize(100);
    }

    private static HttpClientOptions createClientOptionsHttp2(Map<String, String> clientProps, boolean tls) {
        int sizeInt;
        String size = clientProps.get("ksql.internal.http2.max.pool.size");
        if (size != null) {
            try {
                sizeInt = Integer.parseInt(size);
            }
            catch (NumberFormatException e) {
                LOG.error("Bad int passed in for ksql.internal.http2.max.pool.size, using 3000", (Throwable)e);
                sizeInt = 3000;
            }
        } else {
            sizeInt = 3000;
        }
        return new HttpClientOptions().setHttp2MultiplexingLimit(1).setHttp2MaxPoolSize(sizeInt).setProtocolVersion(HttpVersion.HTTP_2).setUseAlpn(tls);
    }
}

