/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.util;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.engine.KsqlEngine;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.schema.registry.SchemaRegistryUtil;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.ExecutorUtil;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.QueryMetadata;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClusterTerminator {
    private static final Logger LOGGER = LogManager.getLogger(ClusterTerminator.class);
    private final KsqlEngine ksqlEngine;
    private final ServiceContext serviceContext;
    private final List<String> managedTopics;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ClusterTerminator(KsqlEngine ksqlEngine, ServiceContext serviceContext, List<String> managedTopics) {
        Objects.requireNonNull(ksqlEngine, "ksqlEngine is null.");
        this.ksqlEngine = ksqlEngine;
        this.serviceContext = Objects.requireNonNull(serviceContext);
        this.managedTopics = ImmutableList.copyOf((Collection)Objects.requireNonNull(managedTopics, "managedTopics"));
    }

    public void terminateCluster(List<String> deleteTopicPatterns) {
        this.terminatePersistentQueries();
        this.deleteSinkTopics(deleteTopicPatterns);
        this.deleteTopics(this.managedTopics);
        this.ksqlEngine.close();
    }

    private void terminatePersistentQueries() {
        this.ksqlEngine.getPersistentQueries().forEach(QueryMetadata::close);
    }

    private void deleteSinkTopics(List<String> deleteTopicPatterns) {
        if (deleteTopicPatterns.isEmpty()) {
            return;
        }
        List<Pattern> patterns = deleteTopicPatterns.stream().map(Pattern::compile).collect(Collectors.toList());
        List<DataSource> toDelete = ClusterTerminator.getSourcesToDelete(patterns, this.ksqlEngine.getMetaStore());
        this.deleteTopics(ClusterTerminator.topicNames(toDelete));
        this.cleanUpSinkSchemas(ClusterTerminator.subjectNames(toDelete));
    }

    private List<String> filterNonExistingTopics(Collection<String> topicList) {
        Set existingTopicNames = this.serviceContext.getTopicClient().listTopicNames();
        return topicList.stream().filter(existingTopicNames::contains).collect(Collectors.toList());
    }

    private void deleteTopics(Collection<String> topicsToBeDeleted) {
        try {
            ExecutorUtil.executeWithRetries(() -> this.serviceContext.getTopicClient().deleteTopics(this.filterNonExistingTopics(topicsToBeDeleted)), (ExecutorUtil.RetryBehaviour)ExecutorUtil.RetryBehaviour.ALWAYS);
        }
        catch (TopicDeletionDisabledException e) {
            LOGGER.info("Did not delete any topics: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            throw new KsqlException("Exception while deleting topics: " + StringUtils.join(topicsToBeDeleted, (String)", "));
        }
    }

    private void cleanUpSinkSchemas(Collection<String> subjectsToDelete) {
        Set knownSubject = SchemaRegistryUtil.getSubjectNames((SchemaRegistryClient)this.serviceContext.getSchemaRegistryClient()).collect(Collectors.toSet());
        subjectsToDelete.retainAll(knownSubject);
        subjectsToDelete.forEach(this::deleteSubject);
    }

    private void deleteSubject(String subject) {
        try {
            SchemaRegistryUtil.deleteSubjectWithRetries((SchemaRegistryClient)this.serviceContext.getSchemaRegistryClient(), (String)subject);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to clean up Avro schema for subject: " + subject, (Throwable)e);
        }
    }

    private static List<DataSource> getSourcesToDelete(List<Pattern> patterns, MetaStore metaStore) {
        Predicate<String> predicate = topicName -> patterns.stream().anyMatch(pattern -> pattern.matcher((CharSequence)topicName).matches());
        return metaStore.getAllDataSources().values().stream().filter(DataSource::isCasTarget).filter(s -> predicate.test(s.getKsqlTopic().getKafkaTopicName())).collect(Collectors.toList());
    }

    private static Set<String> topicNames(List<DataSource> sources) {
        return sources.stream().map(DataSource::getKsqlTopic).map(KsqlTopic::getKafkaTopicName).collect(Collectors.toSet());
    }

    private static Set<String> subjectNames(List<DataSource> sources) {
        HashSet<String> subjects = new HashSet<String>();
        for (DataSource s : sources) {
            String valueFormat;
            String keyFormat = s.getKsqlTopic().getKeyFormat().getFormat();
            if (FormatFactory.fromName((String)keyFormat).supportsFeature(SerdeFeature.SCHEMA_INFERENCE)) {
                subjects.add(KsqlConstants.getSRSubject((String)s.getKafkaTopicName(), (boolean)true));
            }
            if (!FormatFactory.fromName((String)(valueFormat = s.getKsqlTopic().getValueFormat().getFormat())).supportsFeature(SerdeFeature.SCHEMA_INFERENCE)) continue;
            subjects.add(KsqlConstants.getSRSubject((String)s.getKafkaTopicName(), (boolean)false));
        }
        return subjects;
    }
}

