/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.util;

import io.confluent.ksql.services.KafkaTopicClient;
import io.confluent.ksql.util.KsqlConfig;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Optional;

public final class CommandTopicBackupUtil {
    private CommandTopicBackupUtil() {
    }

    public static String backupLocation(KsqlConfig ksqlConfig) {
        return Optional.ofNullable(ksqlConfig.getString("ksql.metastore.backup.location")).orElse("");
    }

    public static boolean commandTopicMissingWithValidBackup(String commandTopic, KafkaTopicClient kafkaTopicClient, KsqlConfig ksqlConfig) {
        File backupDir;
        if (kafkaTopicClient.isTopicExists(commandTopic)) {
            return false;
        }
        String backupLocation = CommandTopicBackupUtil.backupLocation(ksqlConfig);
        if (!backupLocation.isEmpty() && (backupDir = new File(backupLocation)).exists() && backupDir.isDirectory()) {
            int fileCount = Optional.ofNullable(backupDir.listFiles()).map(Array::getLength).orElse(0);
            return fileCount > 0;
        }
        return false;
    }
}

