/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.util;

import io.confluent.ksql.rest.entity.FieldInfo;
import io.confluent.ksql.rest.entity.SchemaInfo;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SqlTypeWalker;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlDecimal;
import io.confluent.ksql.schema.ksql.types.SqlMap;
import io.confluent.ksql.schema.ksql.types.SqlStruct;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class EntityUtil {
    private EntityUtil() {
    }

    public static List<FieldInfo> buildSourceSchemaEntity(LogicalSchema schema) {
        List<FieldInfo> allFields = schema.columns().stream().map(EntityUtil::toFieldInfo).collect(Collectors.toList());
        if (allFields.isEmpty()) {
            throw new IllegalArgumentException("Root schema should contain columns: " + String.valueOf(schema));
        }
        return allFields;
    }

    public static SchemaInfo schemaInfo(SqlType type) {
        return (SchemaInfo)SqlTypeWalker.visit((SqlType)type, (SqlTypeWalker.Visitor)new Converter());
    }

    private static FieldInfo toFieldInfo(Column column) {
        return new FieldInfo(column.name().text(), EntityUtil.schemaInfo(column.type()), EntityUtil.fieldType(column), column.headerKey());
    }

    private static Optional<FieldInfo.FieldType> fieldType(Column column) {
        switch (column.namespace()) {
            case KEY: {
                return Optional.of(FieldInfo.FieldType.KEY);
            }
            case HEADERS: {
                return Optional.of(FieldInfo.FieldType.HEADER);
            }
        }
        return Optional.empty();
    }

    private static final class Converter
    implements SqlTypeWalker.Visitor<SchemaInfo, FieldInfo> {
        private Converter() {
        }

        public SchemaInfo visitType(SqlType schema) {
            return new SchemaInfo(schema.baseType(), null, null);
        }

        public SchemaInfo visitArray(SqlArray type, SchemaInfo element) {
            return new SchemaInfo(SqlBaseType.ARRAY, null, element);
        }

        public SchemaInfo visitMap(SqlMap type, SchemaInfo key, SchemaInfo value) {
            return new SchemaInfo(SqlBaseType.MAP, null, value);
        }

        public SchemaInfo visitStruct(SqlStruct type, List<? extends FieldInfo> fields) {
            return new SchemaInfo(SqlBaseType.STRUCT, fields, null);
        }

        public FieldInfo visitField(SqlStruct.Field field, SchemaInfo type) {
            return new FieldInfo(field.name(), type, Optional.empty());
        }

        public SchemaInfo visitDecimal(SqlDecimal type) {
            return new SchemaInfo(SqlBaseType.DECIMAL, null, null, type.toParametersMap());
        }
    }
}

