/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.util;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.rest.server.KsqlServerMain;
import io.confluent.ksql.util.JavaSystemExit;
import io.confluent.ksql.util.SystemExit;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.apache.kafka.streams.processor.internals.StreamThread;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KsqlUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final Runnable flusher;
    private final Optional<CountDownLatch> countDownLatch;
    private static final Logger log = LogManager.getLogger(KsqlServerMain.class);

    public KsqlUncaughtExceptionHandler(Runnable flusher) {
        this(flusher, Optional.empty());
    }

    @VisibleForTesting
    public KsqlUncaughtExceptionHandler(Runnable flusher, Optional<CountDownLatch> countDownLatch) {
        this.flusher = flusher;
        this.countDownLatch = countDownLatch;
    }

    @Override
    @SuppressFBWarnings
    public void uncaughtException(Thread t, Throwable e) {
        this.uncaughtExceptionInternal(t, e, (SystemExit)new JavaSystemExit());
    }

    void uncaughtExceptionInternal(Thread t, Throwable e, SystemExit systemExit) {
        if (t instanceof StreamThread) {
            this.countDownLatch.ifPresent(CountDownLatch::countDown);
            return;
        }
        log.error("Unhandled exception caught in thread {}.", (Object)t.getName(), (Object)e);
        System.err.println("Unhandled exception caught in thread: " + t.getName() + ". Exception:" + e.getMessage());
        this.flusher.run();
        systemExit.exit(-1);
    }
}

