/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.util;

import io.confluent.ksql.util.KsqlRateLimitException;
import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeCount;

public class RateLimiter {
    private final com.google.common.util.concurrent.RateLimiter rateLimiter;
    private final Sensor rejectSensor;

    public RateLimiter(double permitsPerSecond, String metricNamespace, Metrics metrics, Map<String, String> metricsTags) {
        this.rateLimiter = com.google.common.util.concurrent.RateLimiter.create((double)permitsPerSecond);
        this.rejectSensor = metrics.sensor("pull-rate-limit-rejects");
        this.rejectSensor.add(new MetricName(metricNamespace + "-rate-limit-reject-count", "_confluent-ksql-limits", "The number of requests rejected by this limiter", metricsTags), (MeasurableStat)new CumulativeCount());
    }

    public void checkLimit() {
        if (!this.rateLimiter.tryAcquire()) {
            this.rejectSensor.record();
            throw new KsqlRateLimitException("Host is at rate limit for pull queries. Currently set to " + this.rateLimiter.getRate() + " qps.");
        }
    }
}

