/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.Optional;
import java.util.OptionalInt;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.raft.ElectionState;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.NomineeState;
import org.apache.kafka.raft.QuorumState;
import org.apache.kafka.raft.ReplicaKey;
import org.apache.kafka.raft.VoterSet;
import org.apache.kafka.raft.internals.EpochElection;
import org.slf4j.Logger;

public class ProspectiveState
implements NomineeState {
    private final int localId;
    private final int epoch;
    private final OptionalInt leaderId;
    private final Endpoints leaderEndpoints;
    private final Optional<ReplicaKey> votedKey;
    private final VoterSet voters;
    private final EpochElection epochElection;
    private final Optional<LogOffsetMetadata> highWatermark;
    private final int retries;
    private final long electionTimeoutMs;
    private final Timer electionTimer;
    private final Logger log;

    public ProspectiveState(Time time, int localId, int epoch, OptionalInt leaderId, Endpoints leaderEndpoints, Optional<ReplicaKey> votedKey, VoterSet voters, Optional<LogOffsetMetadata> highWatermark, int retries, int electionTimeoutMs, LogContext logContext) {
        this.localId = localId;
        this.epoch = epoch;
        this.leaderId = leaderId;
        this.leaderEndpoints = leaderEndpoints;
        this.votedKey = votedKey;
        this.voters = voters;
        this.highWatermark = highWatermark;
        this.retries = retries;
        this.electionTimeoutMs = electionTimeoutMs;
        this.electionTimer = time.timer((long)electionTimeoutMs);
        this.log = logContext.logger(ProspectiveState.class);
        this.epochElection = new EpochElection(voters.voterKeys());
        this.epochElection.recordVote(localId, true);
    }

    public Optional<ReplicaKey> votedKey() {
        return this.votedKey;
    }

    @Override
    public EpochElection epochElection() {
        return this.epochElection;
    }

    public int retries() {
        return this.retries;
    }

    @Override
    public boolean recordGrantedVote(int remoteNodeId) {
        return this.epochElection().recordVote(remoteNodeId, true);
    }

    @Override
    public boolean recordRejectedVote(int remoteNodeId) {
        if (remoteNodeId == this.localId) {
            throw new IllegalArgumentException("Attempted to reject vote from ourselves");
        }
        return this.epochElection().recordVote(remoteNodeId, false);
    }

    @Override
    public boolean canGrantVote(ReplicaKey replicaKey, boolean isLogUpToDate, boolean isPreVote) {
        return QuorumState.unattachedOrProspectiveCanGrantVote(this.leaderId, this.votedKey, this.epoch, replicaKey, isLogUpToDate, isPreVote, this.log);
    }

    @Override
    public boolean hasElectionTimeoutExpired(long currentTimeMs) {
        this.electionTimer.update(currentTimeMs);
        return this.electionTimer.isExpired();
    }

    @Override
    public long remainingElectionTimeMs(long currentTimeMs) {
        this.electionTimer.update(currentTimeMs);
        return this.electionTimer.remainingMs();
    }

    @Override
    public ElectionState election() {
        if (this.leaderId.isPresent()) {
            return ElectionState.withElectedLeader(this.epoch, this.leaderId.getAsInt(), this.votedKey, this.voters.voterIds());
        }
        if (this.votedKey.isPresent()) {
            return ElectionState.withVotedCandidate(this.epoch, this.votedKey.get(), this.voters.voterIds());
        }
        return ElectionState.withUnknownLeader(this.epoch, this.voters.voterIds());
    }

    @Override
    public int epoch() {
        return this.epoch;
    }

    @Override
    public Endpoints leaderEndpoints() {
        return this.leaderEndpoints;
    }

    @Override
    public Optional<LogOffsetMetadata> highWatermark() {
        return this.highWatermark;
    }

    public String toString() {
        return String.format("ProspectiveState(epoch=%d, leaderId=%s, retries=%d, votedKey=%s, epochElection=%s, electionTimeoutMs=%s, highWatermark=%s)", this.epoch, this.leaderId, this.retries, this.votedKey, this.epochElection, this.electionTimeoutMs, this.highWatermark);
    }

    @Override
    public String name() {
        return "Prospective";
    }

    @Override
    public void close() {
    }
}

