/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.concurrent;

import io.confluent.kafka.concurrent.EventExecutor;
import io.confluent.kafka.concurrent.VoidCallable;
import java.util.OptionalInt;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class DefaultEventExecutor
implements EventExecutor {
    private final ScheduledThreadPoolExecutor scheduler;
    private final int pendingTasksCapacity;
    private final AtomicInteger pendingTasksCounter = new AtomicInteger(0);
    private OptionalInt prevQueueSize = OptionalInt.empty();
    private final AtomicReference<CompletableFuture<Void>> shutdownFuture = new AtomicReference<Object>(null);

    public DefaultEventExecutor(ThreadFactory threadFactory, int pendingTasksCapacity) {
        this.scheduler = new ScheduledThreadPoolExecutor(1, threadFactory);
        this.scheduler.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.scheduler.setRemoveOnCancelPolicy(true);
        this.pendingTasksCapacity = pendingTasksCapacity;
    }

    @Override
    public CompletableFuture<Void> submit(Runnable task) {
        return this.submit(new VoidCallable(task));
    }

    @Override
    public <T> CompletableFuture<T> submit(Callable<T> task) {
        this.ensureAccepting();
        Task<T> submitter = new Task<T>(task);
        Future<?> scheduledFuture = this.scheduler.submit(submitter);
        this.pendingTasksCounter.incrementAndGet();
        this.hookupCancellation(scheduledFuture, submitter);
        return submitter.future();
    }

    @Override
    public CompletableFuture<Void> schedule(Runnable task, long delay, TimeUnit unit) {
        return this.schedule(new VoidCallable(task), delay, unit);
    }

    @Override
    public <T> CompletableFuture<T> schedule(Callable<T> task, long delay, TimeUnit unit) {
        this.ensureAccepting();
        Task<T> submitter = new Task<T>(task);
        ScheduledFuture<?> scheduledFuture = this.scheduler.schedule(submitter, delay, unit);
        this.pendingTasksCounter.incrementAndGet();
        this.hookupCancellation(scheduledFuture, submitter);
        return submitter.future();
    }

    @Override
    public CompletableFuture<Void> shutdown() {
        if (this.shutdownFuture.compareAndSet(null, new CompletableFuture())) {
            this.scheduleShutdown();
        }
        return this.shutdownFuture.get();
    }

    private void scheduleShutdown() {
        this.scheduler.submit(() -> {
            int currentSize = this.scheduler.getQueue().size();
            if (this.prevQueueSize.isPresent() && currentSize == this.prevQueueSize.getAsInt()) {
                this.scheduler.shutdown();
                this.shutdownFuture.get().complete(null);
                return;
            }
            this.prevQueueSize = OptionalInt.of(currentSize);
            this.scheduleShutdown();
        });
    }

    private void hookupCancellation(Future<?> scheduledFuture, Task<?> submitter) {
        submitter.future().whenComplete((value, exception) -> {
            if (exception instanceof CancellationException && scheduledFuture.cancel(false)) {
                this.pendingTasksCounter.decrementAndGet();
            }
        });
    }

    private void ensureAccepting() {
        if (this.shutdownFuture.get() != null) {
            throw new RejectedExecutionException("event executor was shutdown");
        }
        if (this.pendingTasksCounter.get() >= this.pendingTasksCapacity) {
            throw new RejectedExecutionException(String.format("pending task capacity reached %s", this.pendingTasksCapacity));
        }
    }

    private final class Task<T>
    implements Runnable {
        private final Callable<T> task;
        private final CompletableFuture<T> future = new CompletableFuture();

        Task(Callable<T> task) {
            this.task = task;
        }

        CompletableFuture<T> future() {
            return this.future;
        }

        @Override
        public void run() {
            try {
                DefaultEventExecutor.this.pendingTasksCounter.decrementAndGet();
                if (!this.future.isDone()) {
                    this.future.complete(this.task.call());
                }
            }
            catch (Throwable e) {
                this.future.completeExceptionally(e);
            }
        }
    }
}

