/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.common.Configurable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpiffeIdPrincipalExtractor
implements Configurable {
    public static final Logger log = LoggerFactory.getLogger(SpiffeIdPrincipalExtractor.class);
    private static final String RULE_PATTERN = "RULE:spiffe://([^!]*)!\\s*([^!]*)\\s*!(\\s*[LU]?\\s*)|(.*?)";
    private static final Pattern RULE_SPLITTER = Pattern.compile("\\s*(RULE:spiffe://([^!]*)!\\s*([^!]*)\\s*!(\\s*[LU]?\\s*)|(.*?))\\s*(,\\s*|$)");
    private static final Pattern RULE_PARSER = Pattern.compile("RULE:spiffe://([^!]*)!\\s*([^!]*)\\s*!(\\s*[LU]?\\s*)|(.*?)");
    private List<PrincipalExtractionRule> principalExtractionRules;

    public SpiffeIdPrincipalExtractor() {
    }

    public SpiffeIdPrincipalExtractor(String spiffeIdPrincipalMappingRules) {
        this.principalExtractionRules = SpiffeIdPrincipalExtractor.parseRules(SpiffeIdPrincipalExtractor.splitRules(spiffeIdPrincipalMappingRules));
    }

    public void configure(Map<String, ?> configs) {
        Object principalExtractionRulesConfig = configs.get("confluent.spiffe.id.principal.extraction.rules");
        this.principalExtractionRules = SpiffeIdPrincipalExtractor.parseRules(SpiffeIdPrincipalExtractor.splitRules(principalExtractionRulesConfig == null ? "" : principalExtractionRulesConfig.toString()));
    }

    public static SpiffeIdPrincipalExtractor fromRules(String spiffeIdPrincipalMappingRules) {
        return new SpiffeIdPrincipalExtractor(spiffeIdPrincipalMappingRules);
    }

    private static List<String> splitRules(String spiffeIdPrincipalMappingRules) {
        if (spiffeIdPrincipalMappingRules == null) {
            spiffeIdPrincipalMappingRules = "";
        }
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = RULE_SPLITTER.matcher(spiffeIdPrincipalMappingRules.trim());
        while (matcher.find()) {
            result.add(matcher.group(1));
        }
        return result;
    }

    private static List<PrincipalExtractionRule> parseRules(List<String> rules) {
        ArrayList<PrincipalExtractionRule> result = new ArrayList<PrincipalExtractionRule>();
        for (String rule : rules) {
            Matcher matcher = RULE_PARSER.matcher(rule);
            if (!matcher.lookingAt()) {
                log.error("Encountered Invalid Rule: " + rule);
                continue;
            }
            if (rule.length() != matcher.end()) {
                log.error("Encountered Invalid Rule: `" + rule + "`, unmatched substring: `" + rule.substring(matcher.end()) + "`");
                continue;
            }
            if (matcher.group(1) == null || matcher.group(1).isEmpty() || matcher.group(2) == null || matcher.group(2).isEmpty()) continue;
            result.add(new PrincipalExtractionRule("spiffe://" + matcher.group(1), matcher.group(2), "L".equals(matcher.group(3).trim()), "U".equals(matcher.group(3).trim())));
        }
        return result;
    }

    public List<String> extractPrincipals(String spiffeId) {
        ArrayList<String> extractedPrincipals = new ArrayList<String>();
        for (PrincipalExtractionRule rule : this.principalExtractionRules) {
            String principal = rule.extractPrincipal(spiffeId);
            if (principal == null) continue;
            extractedPrincipals.add(principal);
        }
        extractedPrincipals.add(spiffeId);
        return extractedPrincipals;
    }

    public String toString() {
        return "SpiffeIdPrincipalExtractor(rules = " + String.valueOf(this.principalExtractionRules) + ")";
    }

    public int principalExtractionRulesCount() {
        return this.principalExtractionRules.size();
    }

    private static class PrincipalExtractionRule {
        private static final Pattern BACK_REFERENCE_PATTERN = Pattern.compile("\\$(\\d+)");
        private final Pattern idPattern;
        private final String extraction;
        private final boolean toLowerCase;
        private final boolean toUpperCase;

        PrincipalExtractionRule(String idPattern, String extraction, boolean toLowerCase, boolean toUpperCase) {
            this.idPattern = idPattern == null ? null : Pattern.compile(idPattern);
            this.extraction = extraction;
            this.toLowerCase = toLowerCase;
            this.toUpperCase = toUpperCase;
        }

        String extractPrincipal(String spiffeId) {
            String principal = null;
            Matcher matcher = this.idPattern.matcher(spiffeId);
            if (!matcher.matches()) {
                return null;
            }
            principal = spiffeId.replaceAll(this.idPattern.pattern(), this.escapeLiteralBackReferences(this.extraction, matcher.groupCount()));
            if (this.toLowerCase) {
                principal = principal.toLowerCase(Locale.ENGLISH);
            } else if (this.toUpperCase) {
                principal = principal.toUpperCase(Locale.ENGLISH);
            }
            return principal;
        }

        private String escapeLiteralBackReferences(String unescaped, int numCapturingGroups) {
            if (numCapturingGroups == 0) {
                return unescaped;
            }
            String value = unescaped;
            Matcher backRefMatcher = BACK_REFERENCE_PATTERN.matcher(value);
            while (backRefMatcher.find()) {
                int backRefIndex;
                String backRefNum = backRefMatcher.group(1);
                if (backRefNum.startsWith("0")) continue;
                for (backRefIndex = Integer.parseInt(backRefNum); backRefIndex > numCapturingGroups && backRefIndex >= 10; backRefIndex /= 10) {
                }
                if (backRefIndex <= numCapturingGroups) continue;
                StringBuilder sb = new StringBuilder(value.length() + 1);
                int groupStart = backRefMatcher.start(1);
                sb.append(value.substring(0, groupStart - 1));
                sb.append("\\");
                sb.append(value.substring(groupStart - 1));
                value = sb.toString();
            }
            return value;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("RULE:");
            if (this.idPattern != null) {
                buf.append(this.idPattern);
            }
            buf.append("!");
            if (this.extraction != null) {
                buf.append(this.extraction);
            }
            buf.append("!");
            if (this.toLowerCase) {
                buf.append("L");
            } else if (this.toUpperCase) {
                buf.append("U");
            }
            return buf.toString();
        }
    }
}

