/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.quota;

import io.confluent.kafka.multitenant.quota.TenantClientQuotaConsumer;
import io.confluent.protobuf.cloud.events.v1.ClientQuotaKey;
import io.confluent.protobuf.cloud.events.v1.ClientQuotaValue;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MessageFormatter;

public class TenantClientQuotaFormatter
implements MessageFormatter {
    public void writeTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
        try {
            if (consumerRecord.key() != null) {
                ClientQuotaValue value = null;
                ClientQuotaKey key = TenantClientQuotaConsumer.parseKey(consumerRecord, 0L);
                if (consumerRecord.value() != null) {
                    value = TenantClientQuotaConsumer.parseValue(consumerRecord, 0L, key);
                }
                output.print(consumerRecord.timestamp());
                output.write(":".getBytes(StandardCharsets.UTF_8));
                output.write(key.getClusterId().getBytes(StandardCharsets.UTF_8));
                output.write(":".getBytes(StandardCharsets.UTF_8));
                output.write(key.getPrincipal().getBytes(StandardCharsets.UTF_8));
                output.write("::".getBytes(StandardCharsets.UTF_8));
                if (value != null) {
                    output.print(value.getIngressBytesRate());
                    output.write(":".getBytes(StandardCharsets.UTF_8));
                    output.print(value.getEgressBytesRate());
                } else {
                    output.write("NULL".getBytes(StandardCharsets.UTF_8));
                }
            } else {
                output.write("NULL key".getBytes(StandardCharsets.UTF_8));
            }
            output.write("\n".getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
    }
}

