/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.jwt;

import io.confluent.kafka.clients.plugins.auth.jwt.AsyncHttpsJwks;
import io.confluent.kafka.clients.plugins.auth.jwt.AsyncHttpsJwksVerificationKeyResolver;
import io.confluent.kafka.clients.plugins.auth.jwt.CloseableVerificationKeyResolver;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.kafka.common.config.ConfigException;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.lang.UnresolvableKeyException;

public final class JkuVerificationKeyResolver
implements CloseableVerificationKeyResolver {
    private final Function<String, AsyncHttpsJwks> httpsJwksSupplier;
    private final Collection<String> domainWhitelist;
    private final boolean disambiguateKey;
    private final String requiredProtocol;
    private volatile boolean isRunning;
    private final ConcurrentHashMap<String, CloseableVerificationKeyResolver> jkuKeyResolverCache = new ConcurrentHashMap();

    public JkuVerificationKeyResolver(Collection<String> domainWhitelist) {
        this(domainWhitelist, false);
    }

    public JkuVerificationKeyResolver(Collection<String> domainWhitelist, boolean unsafeAllowed) {
        this(AsyncHttpsJwks::new, domainWhitelist, false, unsafeAllowed);
    }

    public JkuVerificationKeyResolver(Function<String, AsyncHttpsJwks> httpsJwksSupplier, Collection<String> domainWhitelist, boolean disambiguateKey, boolean unsafeAllowed) {
        if (domainWhitelist == null || domainWhitelist.isEmpty()) {
            throw new ConfigException("domainWhiteList must contain at least one entry");
        }
        this.httpsJwksSupplier = httpsJwksSupplier;
        this.domainWhitelist = domainWhitelist;
        this.disambiguateKey = disambiguateKey;
        this.requiredProtocol = unsafeAllowed ? "http" : "https";
        this.isRunning = true;
    }

    private AsyncHttpsJwksVerificationKeyResolver newVerificationKeyResolver(String jku) {
        return new AsyncHttpsJwksVerificationKeyResolver(this.httpsJwksSupplier.apply(jku), this.disambiguateKey);
    }

    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        if (!this.isRunning) {
            throw new IllegalStateException("Attempt to resolve key while KeyResolver is being shut down");
        }
        String jku = jws.getHeaders().getStringHeaderValue("jku");
        if (!JkuVerificationKeyResolver.hasValidJkuDomain(this.domainWhitelist, this.requiredProtocol, jku)) {
            throw new UnresolvableKeyException("Invalid jku: " + jku);
        }
        CloseableVerificationKeyResolver httpsJwksKeyResolver = this.jkuKeyResolverCache.computeIfAbsent(jku, this::newVerificationKeyResolver);
        return httpsJwksKeyResolver.resolveKey(jws, nestingContext);
    }

    public static boolean hasValidJkuDomain(Collection<String> domainWhitelist, String requiredProtocol, String jku) {
        try {
            URL jkuURL = new URL(jku);
            String jkuDomain = jkuURL.getHost();
            if (requiredProtocol.equals(jkuURL.getProtocol())) {
                return domainWhitelist.stream().anyMatch(domain -> domain.startsWith(".") ? jkuDomain.endsWith((String)domain) : domain.equals(jkuURL.getHost()));
            }
            return false;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    @Override
    public void close() {
        this.isRunning = false;
        this.jkuKeyResolverCache.clear();
    }
}

