/*
 * Decompiled with CFR 0.152.
 */
package io.kcache;

import io.kcache.KeyValueIterator;
import io.kcache.exceptions.CacheInitializationException;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import org.apache.kafka.common.Configurable;

public interface Cache<K, V>
extends SortedMap<K, V>,
Configurable,
Closeable {
    default public boolean isPersistent() {
        return false;
    }

    default public void configure(Map<String, ?> configs) {
    }

    public void init() throws CacheInitializationException;

    public void reset();

    public void sync();

    public Cache<K, V> subCache(K var1, boolean var2, K var3, boolean var4);

    public KeyValueIterator<K, V> range(K var1, boolean var2, K var3, boolean var4);

    public KeyValueIterator<K, V> all();

    public Cache<K, V> descendingCache();

    public void flush();

    public void destroy() throws IOException;

    @Override
    default public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return this.subCache(fromKey, true, toKey, false);
    }

    @Override
    default public SortedMap<K, V> headMap(K toKey) {
        return this.subCache(null, false, toKey, false);
    }

    @Override
    default public SortedMap<K, V> tailMap(K fromKey) {
        return this.subCache(fromKey, true, null, false);
    }
}

