/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.utils;

import com.google.common.collect.ForwardingSortedMap;
import io.kcache.Cache;
import io.kcache.KeyValue;
import io.kcache.KeyValueIterator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class InMemoryCache<K, V>
extends ForwardingSortedMap<K, V>
implements Cache<K, V> {
    private final NavigableMap<K, V> delegate;

    public InMemoryCache() {
        this.delegate = new ConcurrentSkipListMap();
    }

    public InMemoryCache(Comparator<? super K> comparator) {
        this.delegate = new ConcurrentSkipListMap<K, V>(comparator);
    }

    public InMemoryCache(NavigableMap<K, V> delegate) {
        this.delegate = delegate;
    }

    protected SortedMap<K, V> delegate() {
        return this.delegate;
    }

    @Override
    public void init() {
    }

    @Override
    public void reset() {
    }

    @Override
    public void sync() {
    }

    @Override
    public Cache<K, V> subCache(K from, boolean fromInclusive, K to, boolean toInclusive) {
        return new InMemoryCache<K, V>(this.subMap(from, fromInclusive, to, toInclusive));
    }

    private NavigableMap<K, V> subMap(K from, boolean fromInclusive, K to, boolean toInclusive) {
        if (from == null) {
            return this.delegate.headMap(to, toInclusive);
        }
        if (to == null) {
            return this.delegate.tailMap(from, fromInclusive);
        }
        return this.delegate.subMap(from, fromInclusive, to, toInclusive);
    }

    @Override
    public KeyValueIterator<K, V> range(K from, boolean fromInclusive, K to, boolean toInclusive) {
        return new InMemoryKeyValueIterator(this.subMap(from, fromInclusive, to, toInclusive).entrySet().iterator());
    }

    @Override
    public KeyValueIterator<K, V> all() {
        return new InMemoryKeyValueIterator(this.entrySet().iterator());
    }

    @Override
    public Cache<K, V> descendingCache() {
        return new InMemoryCache<K, V>(this.delegate.descendingMap());
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public void destroy() {
    }

    private static class InMemoryKeyValueIterator<K, V>
    implements KeyValueIterator<K, V> {
        private final Iterator<Map.Entry<K, V>> iter;

        private InMemoryKeyValueIterator(Iterator<Map.Entry<K, V>> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public KeyValue<K, V> next() {
            Map.Entry<K, V> entry = this.iter.next();
            return new KeyValue<K, V>(entry.getKey(), entry.getValue());
        }

        @Override
        public void close() {
        }
    }
}

