/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authorizer;

import io.confluent.security.authorizer.AuthorizePolicy;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.roledefinitions.Operation;
import io.confluent.security.roledefinitions.PermissionType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;

public abstract class AccessRule
implements AuthorizePolicy {
    public static final String ALL_HOSTS = "*";
    public static final KafkaPrincipal WILDCARD_USER_PRINCIPAL = new KafkaPrincipal("User", "*");
    public static final String GROUP_PRINCIPAL_TYPE = "Group";
    public static final KafkaPrincipal WILDCARD_GROUP_PRINCIPAL = new KafkaPrincipal("Group", "*");
    private final ResourcePattern resourcePattern;
    private final KafkaPrincipal principal;
    private final PermissionType permissionType;
    private final String host;
    private final Operation operation;
    private final AuthorizePolicy.PolicyType policyType;
    private final Collection<Uuid> clusterLinkIds;

    public AccessRule(ResourcePattern resourcePattern, KafkaPrincipal principal, PermissionType permissionType, String host, Operation operation, AuthorizePolicy.PolicyType policyType) {
        this(resourcePattern, principal, permissionType, host, operation, policyType, Collections.emptySet());
    }

    public AccessRule(ResourcePattern resourcePattern, KafkaPrincipal principal, PermissionType permissionType, String host, Operation operation, AuthorizePolicy.PolicyType policyType, Collection<Uuid> clusterLinkIds) {
        this.resourcePattern = Objects.requireNonNull(resourcePattern);
        this.principal = Objects.requireNonNull(principal);
        this.permissionType = Objects.requireNonNull(permissionType);
        this.host = host;
        this.operation = Objects.requireNonNull(operation);
        this.policyType = Objects.requireNonNull(policyType);
        this.clusterLinkIds = clusterLinkIds;
    }

    public ResourcePattern resourcePattern() {
        return this.resourcePattern;
    }

    public KafkaPrincipal principal() {
        return this.principal;
    }

    public PermissionType permissionType() {
        return this.permissionType;
    }

    public String host() {
        return this.host;
    }

    public Operation operation() {
        return this.operation;
    }

    @Override
    public AuthorizePolicy.PolicyType policyType() {
        return this.policyType;
    }

    public Collection<Uuid> clusterLinkIds() {
        return this.clusterLinkIds;
    }

    public boolean matches(Set<KafkaPrincipal> matchingPrincipals, String host, Operation requestedOperation, PermissionType permissionType) {
        return AccessRule.matches(this.principal, this.host, this.operation, this.permissionType, matchingPrincipals, host, requestedOperation, permissionType);
    }

    public boolean matches(String host, Operation requestedOperation, PermissionType permissionType) {
        return AccessRule.matches(this.host, this.operation, this.permissionType, host, requestedOperation, permissionType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccessRule)) {
            return false;
        }
        AccessRule that = (AccessRule)o;
        return Objects.equals(this.resourcePattern, that.resourcePattern) && Objects.equals(this.principal, that.principal) && Objects.equals(this.permissionType, that.permissionType) && Objects.equals(this.host, that.host) && Objects.equals(this.operation, that.operation) && Objects.equals((Object)this.policyType, (Object)that.policyType) && Objects.equals(this.clusterLinkIds, that.clusterLinkIds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resourcePattern, this.principal, this.permissionType, this.host, this.operation, this.policyType, this.clusterLinkIds});
    }

    public String toString() {
        return String.format("%s has %s permission for operation %s on %s from host %s (source: %s%s)", new Object[]{this.principal, this.permissionType, this.operation, this.resourcePattern, this.host, this.policyType, SecurityUtils.clusterLinkDescription(this.clusterLinkIds)});
    }

    public static Set<KafkaPrincipal> matchingPrincipals(KafkaPrincipal userPrincipal, Collection<KafkaPrincipal> groupPrincipals, KafkaPrincipal wildcardUserPrincipal, KafkaPrincipal wildcardGroupPrincipal) {
        HashSet<KafkaPrincipal> principals = new HashSet<KafkaPrincipal>(groupPrincipals.size() + 4);
        principals.addAll(groupPrincipals);
        if (userPrincipal instanceof ConfluentPrincipal) {
            for (String authorizationId : ((ConfluentPrincipal)userPrincipal).authorizationIds()) {
                principals.add(new KafkaPrincipal("User", authorizationId));
            }
        } else {
            principals.add(new KafkaPrincipal(userPrincipal.getPrincipalType(), userPrincipal.getName()));
        }
        if (wildcardUserPrincipal != null) {
            principals.add(wildcardUserPrincipal);
        }
        if (wildcardGroupPrincipal != null && !groupPrincipals.isEmpty()) {
            principals.add(wildcardGroupPrincipal);
        }
        return principals;
    }

    public static KafkaPrincipal asBaseKafkaPrincipal(KafkaPrincipal principal) {
        return principal.getClass() != KafkaPrincipal.class ? new KafkaPrincipal(principal.getPrincipalType(), principal.getName()) : principal;
    }

    public static boolean matches(KafkaPrincipal rulePrincipal, String ruleHost, Operation ruleOperation, PermissionType rulePermissionType, Set<KafkaPrincipal> matchingPrincipals, String host, Operation requestedOperation, PermissionType permissionType) {
        return rulePermissionType == permissionType && matchingPrincipals.contains(rulePrincipal) && ruleOperation.matches(requestedOperation, permissionType) && (ruleHost.equals(ALL_HOSTS) || ruleHost.equals(host));
    }

    public static boolean matches(String ruleHost, Operation ruleOperation, PermissionType rulePermissionType, String host, Operation requestedOperation, PermissionType permissionType) {
        return rulePermissionType == permissionType && ruleOperation.matches(requestedOperation, permissionType) && (ruleHost.equals(ALL_HOSTS) || ruleHost.equals(host));
    }
}

