/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.provider;

import io.spiffe.bundle.BundleSource;
import io.spiffe.bundle.x509bundle.X509Bundle;
import io.spiffe.exception.SocketEndpointAddressException;
import io.spiffe.exception.X509SourceException;
import io.spiffe.provider.EnvironmentUtils;
import io.spiffe.provider.SpiffeTrustManager;
import io.spiffe.provider.X509SourceManager;
import io.spiffe.provider.exception.SpiffeProviderException;
import io.spiffe.spiffeid.SpiffeId;
import io.spiffe.spiffeid.SpiffeIdUtils;
import io.spiffe.workloadapi.X509Source;
import java.security.KeyStore;
import java.util.Set;
import java.util.function.Supplier;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import lombok.NonNull;

public class SpiffeTrustManagerFactory
extends TrustManagerFactorySpi {
    private static final boolean ACCEPT_ANY_SPIFFE_ID = Boolean.parseBoolean(EnvironmentUtils.getProperty("ssl.spiffe.acceptAll", "false"));
    private static final Supplier<Set<SpiffeId>> DEFAULT_SPIFFE_ID_SET_SUPPLIER = () -> SpiffeIdUtils.toSetOfSpiffeIds((String)EnvironmentUtils.getProperty("ssl.spiffe.accept"));

    @Override
    public TrustManager[] engineGetTrustManagers() {
        X509Source x509Source;
        try {
            x509Source = X509SourceManager.getX509Source();
        }
        catch (X509SourceException e) {
            throw new SpiffeProviderException("The X.509 source could not be created", e);
        }
        catch (SocketEndpointAddressException e) {
            throw new SpiffeProviderException("The Workload API Socket endpoint address configured is not valid", e);
        }
        SpiffeTrustManager spiffeTrustManager = ACCEPT_ANY_SPIFFE_ID ? new SpiffeTrustManager((BundleSource<X509Bundle>)x509Source) : new SpiffeTrustManager((BundleSource<X509Bundle>)x509Source, DEFAULT_SPIFFE_ID_SET_SUPPLIER);
        return new TrustManager[]{spiffeTrustManager};
    }

    public TrustManager[] engineGetTrustManagers(@NonNull BundleSource<X509Bundle> x509BundleSource) {
        if (x509BundleSource == null) {
            throw new NullPointerException("x509BundleSource is marked non-null but is null");
        }
        SpiffeTrustManager spiffeTrustManager = ACCEPT_ANY_SPIFFE_ID ? new SpiffeTrustManager(x509BundleSource) : new SpiffeTrustManager(x509BundleSource, DEFAULT_SPIFFE_ID_SET_SUPPLIER);
        return new TrustManager[]{spiffeTrustManager};
    }

    public TrustManager[] engineGetTrustManagersAcceptAnySpiffeId(@NonNull BundleSource<X509Bundle> x509BundleSource) {
        if (x509BundleSource == null) {
            throw new NullPointerException("x509BundleSource is marked non-null but is null");
        }
        SpiffeTrustManager spiffeTrustManager = new SpiffeTrustManager(x509BundleSource);
        return new TrustManager[]{spiffeTrustManager};
    }

    public TrustManager[] engineGetTrustManagers(@NonNull BundleSource<X509Bundle> x509BundleSource, @NonNull Supplier<Set<SpiffeId>> acceptedSpiffeIdsSupplier) {
        if (x509BundleSource == null) {
            throw new NullPointerException("x509BundleSource is marked non-null but is null");
        }
        if (acceptedSpiffeIdsSupplier == null) {
            throw new NullPointerException("acceptedSpiffeIdsSupplier is marked non-null but is null");
        }
        SpiffeTrustManager spiffeTrustManager = new SpiffeTrustManager(x509BundleSource, acceptedSpiffeIdsSupplier);
        return new TrustManager[]{spiffeTrustManager};
    }

    @Override
    protected void engineInit(KeyStore keyStore) {
    }

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) {
    }
}

