/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.mtls;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CaCertificatesUtils {
    private CaCertificatesUtils() {
    }

    public static X509Certificate[] x509CertificatesFromPem(String pem) throws CertificateException, IOException {
        Collection<? extends Certificate> certificates;
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(pem.getBytes(StandardCharsets.UTF_8));){
            certificates = factory.generateCertificates(inputStream);
        }
        return certificates.toArray(new X509Certificate[0]);
    }

    public static X509Certificate[] x509CertificatesFromPemFile(Path pemFile) throws CertificateException, IOException {
        Collection<? extends Certificate> certificates;
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        try (InputStream inputStream = Files.newInputStream(pemFile, new OpenOption[0]);){
            certificates = factory.generateCertificates(inputStream);
        }
        return certificates.toArray(new X509Certificate[0]);
    }

    public static boolean isCertificateAuthority(X509Certificate cert) {
        return cert.getBasicConstraints() != -1;
    }

    public static X509CRL x509CrlFromPem(String pem) throws CertificateException, IOException, CRLException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        try (ByteArrayInputStream stream = new ByteArrayInputStream(pem.getBytes(StandardCharsets.UTF_8));){
            X509CRL x509CRL = (X509CRL)factory.generateCRL(stream);
            return x509CRL;
        }
    }

    public static String x509CrlToPem(X509CRL crl) throws CRLException {
        Object pemCrl = "-----BEGIN X509 CRL-----\n";
        pemCrl = (String)pemCrl + Base64.getMimeEncoder(64, new byte[]{10}).encodeToString(crl.getEncoded()) + "\n";
        pemCrl = (String)pemCrl + "-----END X509 CRL-----\n";
        return pemCrl;
    }

    public static boolean isSelfSigned(Certificate cert) {
        if (cert == null) {
            throw new IllegalArgumentException("certificate cannot be null");
        }
        try {
            cert.verify(cert.getPublicKey());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Certificate findSigningCert(Certificate signedCert, Collection<Certificate> certificates) {
        if (signedCert == null) {
            throw new IllegalArgumentException("certificate cannot be null");
        }
        if (certificates == null) {
            throw new IllegalArgumentException("certificate collection cannot be null");
        }
        if (CaCertificatesUtils.isSelfSigned(signedCert)) {
            return null;
        }
        for (Certificate certificate : certificates) {
            try {
                signedCert.verify(certificate.getPublicKey());
                return certificate;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static Certificate[] buildCertChain(Certificate[] clientChain, Map<String, Set<Certificate>> providerToCaCertsMapping) {
        if (clientChain == null || clientChain.length == 0) {
            throw new IllegalArgumentException("partial chain cannot be null or empty");
        }
        if (providerToCaCertsMapping == null) {
            throw new IllegalArgumentException("provider to ca certs mapping cannot be null, provide an empty map instead");
        }
        if (providerToCaCertsMapping.isEmpty()) {
            return clientChain;
        }
        List<Certificate> orderedCertChain = CaCertificatesUtils.buildValidChain(clientChain);
        Certificate lastCert = orderedCertChain.get(orderedCertChain.size() - 1);
        for (Set<Certificate> caCerts : providerToCaCertsMapping.values()) {
            for (Certificate caCert : caCerts) {
                try {
                    if (!lastCert.equals(caCert)) {
                        lastCert.verify(caCert.getPublicKey());
                    }
                    orderedCertChain.addAll(caCerts);
                    return orderedCertChain.toArray(new Certificate[0]);
                }
                catch (Exception exception) {
                }
            }
        }
        return orderedCertChain.toArray(new Certificate[0]);
    }

    @VisibleForTesting
    static List<Certificate> buildValidChain(Certificate[] certChain) {
        Certificate lastCert;
        Certificate signingCert;
        int partialChainSize = CaCertificatesUtils.sizeOfValidChain(certChain);
        List validChain = Arrays.stream(certChain, 0, partialChainSize).collect(Collectors.toCollection(ArrayList::new));
        Set remainingCerts = Arrays.stream(certChain, partialChainSize, certChain.length).collect(Collectors.toCollection(HashSet::new));
        while ((signingCert = CaCertificatesUtils.findSigningCert(lastCert = (Certificate)validChain.get(validChain.size() - 1), remainingCerts)) != null) {
            validChain.add(signingCert);
            remainingCerts.remove(signingCert);
        }
        return validChain;
    }

    private static int sizeOfValidChain(Certificate[] certChain) {
        int lastCertIdx = 0;
        for (int i = 0; i < certChain.length - 1; ++i) {
            Certificate cert = certChain[i];
            Certificate issuer = certChain[i + 1];
            try {
                cert.verify(issuer.getPublicKey());
                lastCertIdx = i + 1;
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        return lastCertIdx + 1;
    }
}

