/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.provider.ldap;

import io.confluent.security.auth.provider.ldap.LdapConfig;
import io.confluent.security.auth.provider.ldap.LdapException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.security.auth.Subject;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.authenticator.LoginManager;
import org.apache.kafka.common.security.kerberos.KerberosLogin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapContextCreator {
    private static final Logger log = LoggerFactory.getLogger(LdapContextCreator.class);
    private final LdapConfig config;
    private final Subject subject;

    public LdapContextCreator(LdapConfig config) {
        this.config = config;
        this.subject = this.login();
    }

    private Subject login() {
        String jaasConfigProp = "ldap.sasl.jaas.config";
        Password jaasConfig = (Password)this.config.values().get(jaasConfigProp);
        String authProp = "ldap.java.naming.security.authentication";
        if (jaasConfig == null && !"GSSAPI".equals(this.config.originals().get(authProp))) {
            return new Subject();
        }
        try {
            JaasContext jaasContext = LdapContextCreator.jaasContext(jaasConfig, "GSSAPI");
            HashMap loginConfigs = new HashMap();
            for (Map.Entry entry : this.config.values().entrySet()) {
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (!name.startsWith("ldap.") || value == null) continue;
                loginConfigs.put(name.substring("ldap.".length()), value);
            }
            LoginManager loginManager = LoginManager.acquireLoginManager((JaasContext)jaasContext, (String)"GSSAPI", KerberosLogin.class, loginConfigs);
            return loginManager.subject();
        }
        catch (Exception e) {
            String configSource = jaasConfig != null ? "ldap.sasl.jaas.config" : "static JAAS configuration";
            throw new LdapException("Login using " + configSource + " failed", e);
        }
    }

    Subject subject() {
        return this.subject;
    }

    public InitialLdapContext createLdapContext() throws IOException, NamingException {
        Hashtable<String, String> env = this.config.ldapContextEnvironment;
        return Subject.doAs(this.subject, () -> {
            try {
                InitialLdapContext ldapContext = new InitialLdapContext(env, null);
                log.info("Created LDAP Context with the Provider URL: {}", ldapContext.getEnvironment().get("java.naming.provider.url"));
                return ldapContext;
            }
            catch (NamingException e) {
                throw new LdapException("LDAP context could not be created with provided configs", e);
            }
        });
    }

    public static JaasContext jaasContext(Password jaasConfig, String mechanism) throws Exception {
        ListenerName listenerName = new ListenerName("ldap");
        Map configs = jaasConfig == null ? Collections.emptyMap() : Collections.singletonMap(mechanism.toLowerCase(Locale.ROOT) + ".sasl.jaas.config", jaasConfig);
        return JaasContext.loadServerContext((ListenerName)listenerName, (String)mechanism, configs);
    }
}

