/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.store.kafka.clients;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.confluent.security.authorizer.utils.JsonMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;

public class JsonSerde<T>
implements Serde<T>,
Serializer<T>,
Deserializer<T>,
Configurable {
    protected final Class<T> clazz;

    public JsonSerde(Class<T> clazz) {
        this.clazz = clazz;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.configure(configs);
    }

    public void configure(Map<String, ?> configs) {
    }

    public Serializer<T> serializer() {
        return this;
    }

    public Deserializer<T> deserializer() {
        return this;
    }

    public byte[] serialize(String topic, T data) {
        if (data != null) {
            try {
                return JsonMapper.objectMapper().writeValueAsBytes(data);
            }
            catch (JsonProcessingException e) {
                throw new SerializationException("Data could not be serialized for topic " + topic, (Throwable)e);
            }
        }
        return null;
    }

    public T deserialize(String topic, byte[] data) {
        if (data != null) {
            try {
                return (T)JsonMapper.objectMapper().readValue(data, this.clazz);
            }
            catch (IOException e) {
                throw new SerializationException("Data could not be deserialized for topic " + topic, (Throwable)e);
            }
        }
        return null;
    }

    public void close() {
    }

    public static <T> JsonSerde<T> serde(Class<T> clazz, boolean isKey) {
        JsonSerde<T> serde = new JsonSerde<T>(clazz);
        serde.configure(Collections.emptyMap(), isKey);
        return serde;
    }
}

