/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.store.kafka.clients;

import io.confluent.security.store.KeyValueStore;
import io.confluent.security.store.MetadataStoreStatus;
import io.confluent.security.store.NotMasterWriterException;
import io.confluent.security.store.kafka.clients.StatusListener;
import io.confluent.security.store.kafka.coordinator.MetadataServiceRebalanceListener;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.BufferExhaustedException;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;

public class KafkaPartitionWriter<K, V> {
    private static final int NOT_MASTER_WRITER = -1;
    private static final int MAX_PENDING_WRITES = 10000;
    private static final int MAX_QUEUED_WRITES = 1000000;
    private final Logger log;
    private final TopicPartition topicPartition;
    private final Producer<K, V> producer;
    private final KeyValueStore<K, V> cache;
    private final MetadataServiceRebalanceListener rebalanceListener;
    private final StatusListener statusListener;
    private final Duration refreshTimeout;
    private final Time time;
    private final BlockingQueue<PendingWrite> pendingWrites;
    private final BlockingQueue<QueuedTask> queuedTasks;
    private ScheduledExecutorService executor;
    private MetadataStoreStatus status;
    private int generationId;
    private long lastProducedOffset;
    private long lastConsumedOffset;
    private int lastSuccessfulGenerationId;
    private final InitializationStatus initializationStatus;

    public KafkaPartitionWriter(TopicPartition topicPartition, Producer<K, V> producer, KeyValueStore<K, V> cache, MetadataServiceRebalanceListener rebalanceListener, StatusListener statusListener, Duration refreshTimeout, Time time) {
        this.topicPartition = topicPartition;
        this.producer = producer;
        this.cache = cache;
        this.rebalanceListener = rebalanceListener;
        this.statusListener = statusListener;
        this.refreshTimeout = refreshTimeout;
        this.time = time;
        this.generationId = -1;
        this.status = MetadataStoreStatus.UNKNOWN;
        this.lastSuccessfulGenerationId = -1;
        this.initializationStatus = new InitializationStatus();
        this.pendingWrites = new ArrayBlockingQueue<PendingWrite>(10000);
        this.queuedTasks = new ArrayBlockingQueue<QueuedTask>(1000000);
        LogContext logContext = new LogContext("[PartitionWriter " + String.valueOf(topicPartition) + "]");
        this.log = logContext.logger(KafkaPartitionWriter.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int generationId, K statusKey, V statusValue, ScheduledExecutorService executor) {
        boolean needsStatusUpdate;
        this.log.debug("Starting generation {} for partition writer {}", (Object)generationId, (Object)this.topicPartition);
        KafkaPartitionWriter kafkaPartitionWriter = this;
        synchronized (kafkaPartitionWriter) {
            this.executor = executor;
            needsStatusUpdate = !this.initializationStatus.isInitialized(generationId);
            this.generationId = generationId;
            this.status(needsStatusUpdate ? MetadataStoreStatus.INITIALIZING : MetadataStoreStatus.INITIALIZED);
        }
        if (needsStatusUpdate) {
            this.writeStatus(generationId, statusKey, statusValue, MetadataStoreStatus.INITIALIZING);
        } else {
            this.statusListener.onWriterSuccess(this.topicPartition.partition());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStatus(int generationId, K statusKey, V statusValue, MetadataStoreStatus status) {
        KafkaPartitionWriter kafkaPartitionWriter = this;
        synchronized (kafkaPartitionWriter) {
            if (this.generationId != generationId) {
                return;
            }
            if (status == MetadataStoreStatus.INITIALIZED) {
                if (this.initializationStatus.isInitialized(generationId)) {
                    this.log.debug("Partition writer {} has already completed initialization for generation {}", (Object)this.topicPartition, (Object)generationId);
                    return;
                }
                this.initializationStatus.initializationPending(generationId);
            }
        }
        this.log.debug("writeStatus for Partition writer {} generation {} status {}", new Object[]{this.topicPartition, generationId, statusValue});
        ProducerRecord record = new ProducerRecord(this.topicPartition.topic(), Integer.valueOf(this.topicPartition.partition()), statusKey, statusValue);
        try {
            this.producer.send(record, (metadata, exception) -> {
                if (exception != null) {
                    this.log.error(String.format("Status %s:%s could not be added to auth topic, writer resigning", statusKey, statusValue), (Throwable)exception);
                    this.statusListener.onProduceFailure(this.topicPartition.partition());
                    this.rebalanceListener.onWriterResigned(generationId);
                } else {
                    this.statusListener.onProduceSuccess(this.topicPartition.partition());
                    this.onStatusRecordWriteCompletion(generationId, status, metadata.offset());
                }
            });
        }
        catch (Throwable e) {
            this.log.error("Failed to write status to auth topic. Partition writer {} ", (Object)this.topicPartition, (Object)e);
            this.statusListener.onProduceFailure(this.topicPartition.partition());
            this.rebalanceListener.onWriterResigned(generationId);
        }
    }

    public synchronized void stop() {
        QueuedTask write;
        this.log.debug("Stop generation {} for partition writer {}", (Object)this.generationId, (Object)this.topicPartition);
        this.generationId = -1;
        this.status(MetadataStoreStatus.UNKNOWN);
        this.executor = null;
        while ((write = (QueuedTask)this.queuedTasks.poll()) != null) {
            if (write.future.isDone()) continue;
            write.fail((Throwable)((Object)this.notMasterWriterException()));
        }
    }

    public CompletionStage<Void> write(K key, V value, Integer expectedGenerationId, boolean waitForInitialization, boolean resignOnFailure) {
        CompletableFuture<Void> future;
        block2: {
            future = new CompletableFuture<Void>();
            try {
                this.maybeWrite(key, unused -> value, future, resignOnFailure, false, v -> {
                    if (expectedGenerationId != null && this.generationId != expectedGenerationId) {
                        throw this.notMasterWriterException();
                    }
                    return (!waitForInitialization || this.status == MetadataStoreStatus.INITIALIZED) && this.pendingWrites.remainingCapacity() > 0;
                });
            }
            catch (Throwable t) {
                this.log.trace("Write request failed", t);
                if (future.isDone()) break block2;
                future.completeExceptionally(t);
            }
        }
        return future;
    }

    public CompletionStage<Void> update(K key, Function<V, V> transformer) {
        CompletableFuture<Void> future;
        block2: {
            future = new CompletableFuture<Void>();
            try {
                this.maybeWrite(key, transformer, future, false, false, v -> this.status == MetadataStoreStatus.INITIALIZED && this.pendingWrites.isEmpty());
            }
            catch (Throwable t) {
                this.log.trace("Write request failed", t);
                if (future.isDone()) break block2;
                future.completeExceptionally(t);
            }
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean maybeWrite(K key, Function<V, V> transformer, CompletableFuture<Void> future, boolean resignOnFailure, boolean isQueuedRequest, Predicate<Void> writeCondition) {
        PendingWrite pendingWrite;
        V newValue;
        KafkaPartitionWriter kafkaPartitionWriter = this;
        synchronized (kafkaPartitionWriter) {
            if (this.generationId == -1) {
                throw this.notMasterWriterException();
            }
            if (!writeCondition.test(null)) {
                if (!isQueuedRequest) {
                    this.addToQueue(v -> this.maybeWrite(key, transformer, future, resignOnFailure, true, writeCondition), future);
                }
                return false;
            }
            newValue = transformer.apply(this.cache.get(key));
            pendingWrite = new PendingWrite(this.generationId, key, future, resignOnFailure);
            if (!this.pendingWrites.offer(pendingWrite)) {
                throw new IllegalStateException("Failed to write record, capacity=" + this.pendingWrites.remainingCapacity());
            }
        }
        this.write(key, newValue, pendingWrite);
        return true;
    }

    private void write(K key, V value, PendingWrite pendingWrite) {
        this.log.debug("Writing new record with key {} to partition {} generation id {}", new Object[]{key, this.topicPartition, pendingWrite.generationId});
        ProducerRecord record = new ProducerRecord(this.topicPartition.topic(), Integer.valueOf(this.topicPartition.partition()), key, value);
        try {
            this.producer.send(record, (Callback)pendingWrite);
        }
        catch (Exception e) {
            this.onRecordWriteFailure(pendingWrite, e);
        }
    }

    private void addToQueue(Predicate<Void> task, CompletableFuture<Void> future) {
        QueuedTask queuedTask = new QueuedTask(task, future);
        if (!this.queuedTasks.offer(queuedTask)) {
            throw new BufferExhaustedException("Failed to queue update request");
        }
        queuedTask.scheduleTimeout();
    }

    private void scheduleQueuedTasks() {
        this.notifyAll();
        if (this.generationId != -1 && this.status == MetadataStoreStatus.INITIALIZED) {
            this.executor.submit(() -> {
                QueuedTask queuedTask;
                while ((queuedTask = (QueuedTask)this.queuedTasks.peek()) != null && !queuedTask.future.isDone() && queuedTask.test(null)) {
                    this.queuedTasks.remove(queuedTask);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompletableFuture<Void> incrementalUpdateFuture() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            KafkaPartitionWriter kafkaPartitionWriter = this;
            synchronized (kafkaPartitionWriter) {
                if (!this.maybeCompleteReadyFuture(future)) {
                    this.addToQueue(unused -> this.maybeCompleteReadyFuture(future), future);
                }
            }
        }
        catch (Throwable t) {
            this.log.trace("Update request failed", t);
            future.completeExceptionally(t);
        }
        return future;
    }

    private synchronized boolean maybeCompleteReadyFuture(CompletableFuture<Void> future) {
        if (this.generationId == -1) {
            throw this.notMasterWriterException();
        }
        if (this.status == MetadataStoreStatus.INITIALIZED && this.pendingWrites.isEmpty()) {
            future.complete(null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStatusConsumed(long offset, int newGenerationId, MetadataStoreStatus status, Integer writerBrokerId) {
        this.log.debug("Received new generation id {} for partition writer {} at offset {} status {} generation {} lastSuccessfulGenerationId {} written by broker {}", new Object[]{newGenerationId, this.topicPartition, offset, status, this.generationId, this.lastSuccessfulGenerationId, writerBrokerId});
        Integer resignGenerationId = null;
        KafkaPartitionWriter kafkaPartitionWriter = this;
        synchronized (kafkaPartitionWriter) {
            this.lastConsumedOffset = offset;
            if (status == MetadataStoreStatus.INITIALIZED && newGenerationId > this.lastSuccessfulGenerationId) {
                this.lastSuccessfulGenerationId = newGenerationId;
                if (this.generationId <= newGenerationId) {
                    this.statusListener.onWriterSuccess(this.topicPartition.partition());
                }
            }
            if (newGenerationId != -1 && newGenerationId == this.generationId && !this.waitUntilPendingOffsetsKnown(offset)) {
                this.log.error("Writer with generation {} resigning because pending writes up to offset {} not cleared within timeout", (Object)this.generationId, (Object)offset);
                resignGenerationId = this.generationId;
            }
            this.maybeCompletePendingWrites(this.lastConsumedOffset);
            this.maybeCancelPendingWrites(newGenerationId);
            if (newGenerationId == this.generationId) {
                this.status(status);
            } else if (newGenerationId > this.generationId && this.generationId != -1) {
                this.log.error("Writer with generation {} resigning because status record with newer generation {} from writer broker {} found at offset {}", new Object[]{this.generationId, newGenerationId, writerBrokerId, offset});
                resignGenerationId = this.generationId;
                if (!this.pendingWrites.isEmpty()) {
                    throw new IllegalStateException("All pending writes of older generation must have been cancelled");
                }
            }
        }
        if (resignGenerationId != null) {
            this.rebalanceListener.onWriterResigned(resignGenerationId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRecordConsumed(ConsumerRecord<K, V> record, V oldValue, boolean expectPendingWriteOnMaster) {
        Integer resignGenerationId = null;
        boolean overwriteValue = false;
        KafkaPartitionWriter kafkaPartitionWriter = this;
        synchronized (kafkaPartitionWriter) {
            long offset = record.offset();
            if (!this.waitUntilPendingOffsetsKnown(offset)) {
                this.log.error("Writer with generation {} resigning because pending writes up to offset {} not cleared within timeout", (Object)this.generationId, (Object)offset);
                resignGenerationId = this.generationId;
            } else if (expectPendingWriteOnMaster && this.status == MetadataStoreStatus.INITIALIZED && !this.pendingWriteExists(offset)) {
                overwriteValue = true;
            }
            this.lastConsumedOffset = offset;
            this.maybeCompletePendingWrites(this.lastConsumedOffset);
        }
        if (overwriteValue) {
            this.write(record.key(), oldValue, this.generationId, true, true);
        }
        if (resignGenerationId != null) {
            this.rebalanceListener.onWriterResigned(resignGenerationId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWriterFailure(int generationId) {
        KafkaPartitionWriter kafkaPartitionWriter = this;
        synchronized (kafkaPartitionWriter) {
            int partition;
            if (generationId >= this.lastSuccessfulGenerationId && this.statusListener.onWriterFailure(partition = this.topicPartition.partition())) {
                String errorMessage = "Partition writer for " + String.valueOf(this.topicPartition) + " failed to recover after timeout at generationId : " + generationId;
                this.log.error(errorMessage);
                this.cache.fail(partition, errorMessage);
            }
        }
    }

    private synchronized void onStatusRecordWriteCompletion(int generationId, MetadataStoreStatus status, long offset) {
        this.lastProducedOffset = offset;
        if (this.generationId == generationId) {
            this.log.debug("Status record of generation {} for partition {} written at offset {}", new Object[]{generationId, this.topicPartition, offset});
            this.statusListener.onWriterSuccess(this.topicPartition.partition());
            if (this.lastConsumedOffset >= offset) {
                this.status(status);
            }
        } else {
            this.log.debug("Discarding status of generation {} for partition writer {} since generation has changed to {}", new Object[]{generationId, this.topicPartition, this.generationId});
        }
        this.scheduleQueuedTasks();
    }

    private synchronized void onRecordWriteCompletion(PendingWrite pendingWrite, int generationId, long offset) {
        this.log.debug("Send callback for record with partition {} generationId {} offset {}", new Object[]{this.topicPartition, generationId, offset});
        this.statusListener.onProduceSuccess(this.topicPartition.partition());
        this.lastProducedOffset = offset;
        pendingWrite.offset = offset;
        this.maybeCompletePendingWrites(this.lastConsumedOffset);
    }

    private synchronized void onRecordWriteFailure(PendingWrite pendingWrite, Exception exception) {
        pendingWrite.fail(exception);
        this.pendingWrites.remove(pendingWrite);
        this.statusListener.onProduceFailure(this.topicPartition.partition());
    }

    private synchronized void status(MetadataStoreStatus newStatus) {
        if (newStatus != this.status) {
            this.log.debug("Changing status from {} to {} for partition writer {}", new Object[]{this.status, newStatus, this.topicPartition});
            this.status = newStatus;
            this.initializationStatus.maybeUpdateStatus(this.generationId, newStatus);
            if (this.status == MetadataStoreStatus.INITIALIZED) {
                this.scheduleQueuedTasks();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resign(int generationId, Exception cause) {
        KafkaPartitionWriter kafkaPartitionWriter = this;
        synchronized (kafkaPartitionWriter) {
            if (this.generationId != generationId) {
                return;
            }
        }
        this.log.error("Writer with generation {} resigning because produce failed", (Object)generationId, (Object)cause);
        this.rebalanceListener.onWriterResigned(generationId);
    }

    private boolean pendingWriteExists(long offset) {
        return this.pendingWrites.stream().anyMatch(p -> p.offset == offset);
    }

    private boolean waitUntilPendingOffsetsKnown(long consumedOffset) {
        return this.waitUntil(unused -> this.pendingWrites.isEmpty() || this.lastProducedOffset >= consumedOffset, false);
    }

    private void maybeCompletePendingWrites(long consumedOffset) {
        Collection completedWrites = this.pendingWrites.stream().filter(pendingWrite -> pendingWrite.maybeComplete(consumedOffset)).collect(Collectors.toList());
        this.pendingWrites.removeAll(completedWrites);
        this.scheduleQueuedTasks();
    }

    private void maybeCancelPendingWrites(int newGenerationId) {
        Collection cancelledWrites = this.pendingWrites.stream().filter(pendingWrite -> pendingWrite.maybeCancel(newGenerationId)).collect(Collectors.toList());
        this.pendingWrites.removeAll(cancelledWrites);
        this.scheduleQueuedTasks();
    }

    private boolean waitUntil(Predicate<Boolean> predicate, boolean failIfNotMaster) {
        try {
            int expectedGenerationId = this.generationId;
            if (this.generationId == -1) {
                if (failIfNotMaster) {
                    throw this.notMasterWriterException();
                }
                return true;
            }
            long endMs = this.time.milliseconds() + this.refreshTimeout.toMillis();
            while (!predicate.test(null)) {
                long remainingMs = endMs - this.time.milliseconds();
                if (remainingMs <= 0L) {
                    return false;
                }
                this.wait(remainingMs);
                if (this.generationId == expectedGenerationId) continue;
                if (failIfNotMaster) {
                    throw this.notMasterWriterException();
                }
                return true;
            }
            return true;
        }
        catch (InterruptedException e) {
            throw new InterruptException(e);
        }
    }

    private NotMasterWriterException notMasterWriterException() {
        return new NotMasterWriterException("This node is currently not the master writer for Metadata Service. This could be a transient exception during writer election.");
    }

    private static class InitializationStatus {
        int generationId = -1;
        Status status = Status.UNKNOWN;

        InitializationStatus() {
        }

        void initializationPending(int generationId) {
            this.maybeUpdateStatus(generationId, Status.INITIALIZATION_PENDING);
        }

        boolean isInitialized(int generationId) {
            return this.generationId != -1 && this.generationId == generationId && this.status == Status.INITIALIZED;
        }

        void maybeUpdateStatus(int generationId, MetadataStoreStatus newStatus) {
            if (generationId == -1 && newStatus == MetadataStoreStatus.UNKNOWN) {
                return;
            }
            if (newStatus == MetadataStoreStatus.INITIALIZED && this.isInitialized(generationId)) {
                return;
            }
            Status initStatus = newStatus == MetadataStoreStatus.INITIALIZED ? Status.INITIALIZED : (newStatus == MetadataStoreStatus.INITIALIZING ? Status.INITIALIZING : Status.UNKNOWN);
            this.maybeUpdateStatus(generationId, initStatus);
        }

        private void maybeUpdateStatus(int generationId, Status newStatus) {
            switch (newStatus.ordinal()) {
                case 0: 
                case 1: {
                    this.status = newStatus;
                    break;
                }
                case 2: {
                    this.status = this.generationId == generationId && this.status == Status.INITIALIZING ? newStatus : Status.UNKNOWN;
                    break;
                }
                case 3: {
                    this.status = this.generationId == generationId && this.status == Status.INITIALIZATION_PENDING ? newStatus : Status.UNKNOWN;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected status " + String.valueOf((Object)newStatus));
                }
            }
            this.generationId = generationId;
        }

        static enum Status {
            UNKNOWN,
            INITIALIZING,
            INITIALIZATION_PENDING,
            INITIALIZED;

        }
    }

    private class QueuedTask
    implements Predicate<Void> {
        private final Predicate<Void> retriableTask;
        private final CompletableFuture<Void> future;
        private Future<?> timeoutFuture;

        QueuedTask(Predicate<Void> retriableTask, CompletableFuture<Void> taskFuture) {
            this.retriableTask = retriableTask;
            this.future = taskFuture;
        }

        public void scheduleTimeout() {
            this.timeoutFuture = KafkaPartitionWriter.this.executor.schedule(this::failWithTimeout, KafkaPartitionWriter.this.refreshTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public boolean test(Void v) {
            boolean done;
            try {
                done = this.retriableTask.test(v);
                if (done) {
                    this.cancelTimeout();
                }
            }
            catch (Throwable t) {
                KafkaPartitionWriter.this.log.error("Failed to run update task", t);
                this.fail(t);
                done = true;
            }
            return done;
        }

        void fail(Throwable t) {
            this.cancelTimeout();
            if (!this.future.isDone()) {
                this.future.completeExceptionally(t);
            }
        }

        void failWithTimeout() {
            this.fail((Throwable)new TimeoutException("Failed to write record within timeout"));
        }

        void cancelTimeout() {
            if (!this.timeoutFuture.isDone()) {
                this.timeoutFuture.cancel(true);
            }
        }
    }

    private class PendingWrite
    implements Callback {
        private final CompletableFuture<Void> future;
        private final int generationId;
        private final K key;
        private final boolean resignOnFailure;
        private long offset;

        PendingWrite(int generationId, K key, CompletableFuture<Void> future, boolean resignOnFailure) {
            this.generationId = generationId;
            this.key = key;
            this.resignOnFailure = resignOnFailure;
            this.future = future;
            this.offset = -1L;
        }

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            KafkaPartitionWriter.this.log.debug("Pending write completed metadata={} partition writer {}", new Object[]{metadata, KafkaPartitionWriter.this.topicPartition, exception});
            if (!this.future.isDone()) {
                if (exception != null) {
                    KafkaPartitionWriter.this.onRecordWriteFailure(this, exception);
                    if (this.resignOnFailure) {
                        KafkaPartitionWriter.this.resign(this.generationId, exception);
                    }
                } else {
                    KafkaPartitionWriter.this.onRecordWriteCompletion(this, this.generationId, metadata.offset());
                }
            }
        }

        void fail(Exception exception) {
            this.future.completeExceptionally(exception);
        }

        boolean maybeCancel(int newGenerationId) {
            if (this.generationId < newGenerationId) {
                KafkaPartitionWriter.this.log.debug("Cancelling pending writes for partition writer {} since rebalance occurred", (Object)KafkaPartitionWriter.this.topicPartition);
                NotMasterWriterException exception = new NotMasterWriterException("Update will be aborted since writer rebalance occurred");
                this.fail((Exception)((Object)exception));
                return true;
            }
            return false;
        }

        boolean maybeComplete(long consumedOffset) {
            if (this.offset >= 0L && this.offset <= consumedOffset) {
                if (consumedOffset == this.offset) {
                    KafkaPartitionWriter.this.log.debug("Completing pending write for partition writer {} since offset {} has been consumed", (Object)KafkaPartitionWriter.this.topicPartition, (Object)this.offset);
                } else {
                    KafkaPartitionWriter.this.log.debug("Completing pending write for partition writer {} with offset {} since a higher offset {} has been consumed", new Object[]{KafkaPartitionWriter.this.topicPartition, this.offset, consumedOffset});
                }
                this.future.complete(null);
                return true;
            }
            return false;
        }

        public String toString() {
            return "PendingWrite(isDone=" + this.future.isDone() + ", generationId=" + this.generationId + ", key=" + String.valueOf(this.key) + ", offset=" + this.offset + ")";
        }
    }
}

