/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.store.kafka.clients;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaUtils {
    private static final Logger log = LoggerFactory.getLogger(KafkaUtils.class);
    private static final int RETRY_BACKOFF_MS = 10;

    public static void waitForTopic(String topic, int numPartitions, Time time, Duration timeout, Function<String, Set<Integer>> describeTopic, Consumer<String> createTopic) {
        long timeoutMs = timeout.toMillis();
        long endTimeMs = time.milliseconds() + timeout.toMillis();
        Set expectedPartitions = IntStream.range(0, numPartitions).boxed().collect(Collectors.toSet());
        Set<Object> partitions = Collections.emptySet();
        boolean created = false;
        while (true) {
            long remainingMs;
            RetriableException describeException = null;
            Throwable createException = null;
            try {
                partitions = describeTopic.apply(topic);
            }
            catch (UnknownTopicOrPartitionException e) {
                if (!created && createTopic != null) {
                    try {
                        log.debug("Topic not found, attempting to create topic {}", (Object)topic);
                        createTopic.accept(topic);
                        created = true;
                    }
                    catch (InvalidReplicationFactorException | RetriableException e1) {
                        log.debug("Failed to create topic " + topic, e1);
                        createException = e1;
                    }
                }
            }
            catch (RetriableException e) {
                log.debug("Partition info could not be obtained for " + topic, (Throwable)e);
                describeException = e;
            }
            if (partitions != null && !partitions.isEmpty()) {
                if (expectedPartitions.equals(partitions)) {
                    log.debug("Topic {} has the expected {} partitions, returning", (Object)topic, (Object)numPartitions);
                    return;
                }
                if (partitions.size() >= numPartitions || (Integer)Collections.max(partitions) > numPartitions - 1) {
                    throw new IllegalStateException(String.format("Unexpected partitions for topic %s: expected 0-%d, got %s", topic, numPartitions - 1, partitions));
                }
                log.debug("Topic {} has partitions {}, waiting for 0-{}", new Object[]{topic, partitions, numPartitions - 1});
            }
            if ((remainingMs = endTimeMs - time.milliseconds()) <= 0L) {
                Throwable cause = createException != null ? createException : describeException;
                String when = cause == createException ? "Create" : "Describe";
                throw new TimeoutException(String.format("Full metadata for topic %s not available within timeout %s ms, available partitions %s, expected 0-%d. This happened during %s call. This means that not enough healthy brokers were found to satisfy partitions required for topic to become usable. If this error is preventing broker startup, you may want to increase timeout using confluent.authorizer.init.timeout.ms config property.", topic, timeoutMs, partitions, numPartitions - 1, when), cause);
            }
            time.sleep(Math.min(remainingMs, 10L));
        }
    }
}

