/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.metrics;

import io.confluent.common.metrics.KafkaMetric;
import io.confluent.common.metrics.MetricName;
import io.confluent.common.metrics.MetricsReporter;
import io.confluent.common.metrics.exceptions.MetricsException;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class JmxReporter
implements MetricsReporter {
    private static final Logger log = LoggerFactory.getLogger(JmxReporter.class);
    private static final Object lock = new Object();
    private final Map<String, KafkaMbean> mbeans = new HashMap<String, KafkaMbean>();
    private String prefix;

    public JmxReporter() {
        this("");
    }

    public JmxReporter(String prefix) {
        this.prefix = prefix;
    }

    public void configure(Map<String, ?> configs) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(List<KafkaMetric> metrics) {
        Object object = lock;
        synchronized (object) {
            for (KafkaMetric metric : metrics) {
                this.addAttribute(metric);
            }
            for (KafkaMbean mbean : this.mbeans.values()) {
                this.reregister(mbean);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void metricChange(KafkaMetric metric) {
        Object object = lock;
        synchronized (object) {
            KafkaMbean mbean = this.addAttribute(metric);
            this.reregister(mbean);
        }
    }

    private KafkaMbean addAttribute(KafkaMetric metric) {
        try {
            MetricName metricName = metric.metricName();
            String mBeanName = this.getMBeanName(metricName);
            if (!this.mbeans.containsKey(mBeanName)) {
                this.mbeans.put(mBeanName, new KafkaMbean(mBeanName));
            }
            KafkaMbean mbean = this.mbeans.get(mBeanName);
            mbean.setAttribute(metricName.name(), metric);
            return mbean;
        }
        catch (JMException e) {
            throw new MetricsException("Error creating mbean attribute for metricName :" + String.valueOf(metric.metricName()), e);
        }
    }

    private String getMBeanName(MetricName metricName) {
        StringBuilder mBeanName = new StringBuilder();
        mBeanName.append(this.prefix);
        mBeanName.append(":type=");
        mBeanName.append(metricName.group());
        for (Map.Entry<String, String> entry : metricName.tags().entrySet()) {
            if (entry.getKey().length() <= 0 || entry.getValue().length() <= 0) continue;
            mBeanName.append(",");
            mBeanName.append(entry.getKey());
            mBeanName.append("=");
            mBeanName.append(entry.getValue());
        }
        return mBeanName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = lock;
        synchronized (object) {
            for (KafkaMbean mbean : this.mbeans.values()) {
                this.unregister(mbean);
            }
        }
    }

    private void unregister(KafkaMbean mbean) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            if (server.isRegistered(mbean.name())) {
                server.unregisterMBean(mbean.name());
            }
        }
        catch (JMException e) {
            throw new MetricsException("Error unregistering mbean", e);
        }
    }

    private void reregister(KafkaMbean mbean) {
        this.unregister(mbean);
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(mbean, mbean.name());
        }
        catch (JMException e) {
            throw new MetricsException("Error registering mbean " + String.valueOf(mbean.name()), e);
        }
    }

    private static class KafkaMbean
    implements DynamicMBean {
        private final ObjectName objectName;
        private final Map<String, KafkaMetric> metrics = new HashMap<String, KafkaMetric>();

        public KafkaMbean(String mbeanName) throws MalformedObjectNameException {
            this.objectName = new ObjectName(mbeanName);
        }

        public ObjectName name() {
            return this.objectName;
        }

        public void setAttribute(String name, KafkaMetric metric) {
            this.metrics.put(name, metric);
        }

        @Override
        public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
            if (this.metrics.containsKey(name)) {
                return this.metrics.get(name).value();
            }
            throw new AttributeNotFoundException("Could not find attribute " + name);
        }

        @Override
        public AttributeList getAttributes(String[] names) {
            try {
                AttributeList list = new AttributeList();
                for (String name : names) {
                    list.add(new Attribute(name, this.getAttribute(name)));
                }
                return list;
            }
            catch (Exception e) {
                log.error("Error getting JMX attribute: ", (Throwable)e);
                return new AttributeList();
            }
        }

        @Override
        public MBeanInfo getMBeanInfo() {
            MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[this.metrics.size()];
            int i = 0;
            for (Map.Entry<String, KafkaMetric> entry : this.metrics.entrySet()) {
                String attribute = entry.getKey();
                KafkaMetric metric = entry.getValue();
                attrs[i] = new MBeanAttributeInfo(attribute, Double.TYPE.getName(), metric.metricName().description(), true, false, false);
                ++i;
            }
            return new MBeanInfo(this.getClass().getName(), "", attrs, null, null, null);
        }

        @Override
        public Object invoke(String name, Object[] params, String[] sig) throws MBeanException, ReflectionException {
            throw new UnsupportedOperationException("Set not allowed.");
        }

        @Override
        public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
            throw new UnsupportedOperationException("Set not allowed.");
        }

        @Override
        public AttributeList setAttributes(AttributeList list) {
            throw new UnsupportedOperationException("Set not allowed.");
        }
    }
}

