/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.rest.ApiJsonMapper;
import io.confluent.ksql.rest.entity.ConsistencyToken;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.confluent.ksql.rest.entity.KsqlHostInfoEntity;
import io.confluent.ksql.rest.entity.PushContinuationToken;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.testing.EffectivelyImmutable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSubTypes(value={})
public final class StreamedRow {
    private static final ObjectMapper OBJECT_MAPPER = ApiJsonMapper.INSTANCE.get();
    private final Optional<Header> header;
    private final Optional<DataRow> row;
    private final Optional<KsqlErrorMessage> errorMessage;
    private final Optional<String> finalMessage;
    private final Optional<KsqlHostInfoEntity> sourceHost;
    private final Optional<PushContinuationToken> continuationToken;
    private final Optional<ConsistencyToken> consistencyToken;

    public static StreamedRow header(QueryId queryId, LogicalSchema schema) {
        return new StreamedRow(Optional.of(Header.of(queryId, schema, Optional.empty())), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static StreamedRow headerProtobuf(QueryId queryId, LogicalSchema columnsSchema, String protoSchema) {
        return new StreamedRow(Optional.of(Header.of(queryId, columnsSchema, Optional.of(protoSchema))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static StreamedRow pushRow(GenericRow value) {
        return new StreamedRow(Optional.empty(), Optional.of(DataRow.row(value.values())), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static StreamedRow continuationToken(PushContinuationToken pushContinuationToken) {
        return new StreamedRow(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(pushContinuationToken), Optional.empty());
    }

    public static StreamedRow pullRow(GenericRow value, Optional<KsqlHostInfoEntity> sourceHost) {
        return new StreamedRow(Optional.empty(), Optional.of(DataRow.row(value.values())), Optional.empty(), Optional.empty(), sourceHost, Optional.empty(), Optional.empty());
    }

    public static StreamedRow pullRowProtobuf(byte[] rowBytes) {
        return new StreamedRow(Optional.empty(), Optional.of(DataRow.rowProtobuf(rowBytes)), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static StreamedRow tombstone(GenericRow columns) {
        return new StreamedRow(Optional.empty(), Optional.of(DataRow.tombstone(columns.values())), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static StreamedRow error(Throwable exception, int errorCode) {
        return new StreamedRow(Optional.empty(), Optional.empty(), Optional.of(new KsqlErrorMessage(errorCode, exception)), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static StreamedRow error(KsqlErrorMessage errorMessage) {
        return new StreamedRow(Optional.empty(), Optional.empty(), Optional.of(errorMessage), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static StreamedRow finalMessage(String finalMessage) {
        return new StreamedRow(Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(finalMessage), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static StreamedRow consistencyToken(ConsistencyToken consistencyToken) {
        return new StreamedRow(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(consistencyToken));
    }

    @JsonCreator
    private StreamedRow(@JsonProperty(value="header") Optional<Header> header, @JsonProperty(value="row") Optional<DataRow> row, @JsonProperty(value="errorMessage") Optional<KsqlErrorMessage> errorMessage, @JsonProperty(value="finalMessage") Optional<String> finalMessage, @JsonProperty(value="sourceHost") Optional<KsqlHostInfoEntity> sourceHost, @JsonProperty(value="continuationToken") Optional<PushContinuationToken> continuationToken, @JsonProperty(value="consistencyToken") Optional<ConsistencyToken> consistencyToken) {
        this.header = Objects.requireNonNull(header, "header");
        this.row = Objects.requireNonNull(row, "row");
        this.errorMessage = Objects.requireNonNull(errorMessage, "errorMessage");
        this.finalMessage = Objects.requireNonNull(finalMessage, "finalMessage");
        this.sourceHost = Objects.requireNonNull(sourceHost, "sourceHost");
        this.continuationToken = Objects.requireNonNull(continuationToken, "continuationToken");
        this.consistencyToken = Objects.requireNonNull(consistencyToken, "consistencyToken");
        StreamedRow.checkUnion(header, row, errorMessage, finalMessage, continuationToken, consistencyToken);
    }

    public Optional<Header> getHeader() {
        return this.header;
    }

    public Optional<DataRow> getRow() {
        return this.row;
    }

    public Optional<KsqlErrorMessage> getErrorMessage() {
        return this.errorMessage;
    }

    public Optional<String> getFinalMessage() {
        return this.finalMessage;
    }

    public Optional<KsqlHostInfoEntity> getSourceHost() {
        return this.sourceHost;
    }

    public Optional<PushContinuationToken> getContinuationToken() {
        return this.continuationToken;
    }

    public Optional<ConsistencyToken> getConsistencyToken() {
        return this.consistencyToken;
    }

    @JsonIgnore
    public boolean isTerminal() {
        return this.finalMessage.isPresent() || this.errorMessage.isPresent();
    }

    public StreamedRow withSourceHost(KsqlHostInfoEntity sourceHost) {
        return new StreamedRow(this.header, this.row, this.errorMessage, this.finalMessage, Optional.ofNullable(sourceHost), this.continuationToken, this.consistencyToken);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamedRow that = (StreamedRow)o;
        return Objects.equals(this.header, that.header) && Objects.equals(this.row, that.row) && Objects.equals(this.errorMessage, that.errorMessage) && Objects.equals(this.finalMessage, that.finalMessage) && Objects.equals(this.sourceHost, that.sourceHost) && Objects.equals(this.continuationToken, that.continuationToken) && Objects.equals(this.consistencyToken, that.consistencyToken);
    }

    public int hashCode() {
        return Objects.hash(this.header, this.row, this.errorMessage, this.finalMessage, this.sourceHost, this.continuationToken, this.consistencyToken);
    }

    public String toString() {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return super.toString();
        }
    }

    private static void checkUnion(Optional<?> ... fs) {
        long count = Arrays.stream(fs).filter(Optional::isPresent).count();
        if (count != 1L) {
            throw new IllegalArgumentException("Exactly one parameter should be non-null. got: " + count);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Header
    extends BaseRow {
        private final QueryId queryId;
        private final LogicalSchema columnsSchema;
        private final Optional<String> protoSchema;

        public static Header of(QueryId queryId, LogicalSchema columnsSchema, Optional<String> protoSchema) {
            return new Header(queryId, columnsSchema, protoSchema);
        }

        public QueryId getQueryId() {
            return this.queryId;
        }

        public LogicalSchema getSchema() {
            return this.columnsSchema;
        }

        public Optional<String> getProtoSchema() {
            return this.protoSchema;
        }

        @JsonCreator
        private static Header jsonCreator(@JsonProperty(value="queryId", required=true) QueryId queryId, @JsonProperty(value="schema") LogicalSchema columnsSchema, @JsonProperty(value="protobufSchema") Optional<String> protoSchema) {
            return new Header(queryId, columnsSchema, protoSchema);
        }

        private Header(QueryId queryId, LogicalSchema columnsSchema, Optional<String> protoSchema) {
            this.queryId = Objects.requireNonNull(queryId, "queryId");
            this.columnsSchema = Objects.requireNonNull(columnsSchema, "columnsSchema");
            this.protoSchema = protoSchema;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Header header = (Header)o;
            return Objects.equals(this.queryId, header.queryId) && Objects.equals(this.columnsSchema, header.columnsSchema) && Objects.equals(this.protoSchema, header.protoSchema);
        }

        public int hashCode() {
            return Objects.hash(this.queryId, this.columnsSchema, this.protoSchema);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class DataRow
    extends BaseRow {
        @EffectivelyImmutable
        private final Optional<List<?>> columns;
        @EffectivelyImmutable
        private final Optional<byte[]> protobufBytes;
        private final boolean tombstone;

        public static DataRow row(List<?> columns) {
            return new DataRow(Optional.of(columns), Optional.empty(), Optional.empty());
        }

        public static DataRow rowProtobuf(byte[] bytes) {
            return new DataRow(Optional.empty(), Optional.of(bytes), Optional.empty());
        }

        public static DataRow tombstone(List<?> columns) {
            return new DataRow(Optional.of(columns), Optional.empty(), Optional.of(true));
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="columns is unmodifiableList()")
        public List<?> getColumns() {
            return this.columns.orElse(Collections.emptyList());
        }

        public Optional<byte[]> getProtobufBytes() {
            return this.protobufBytes;
        }

        public Optional<Boolean> getTombstone() {
            return this.tombstone ? Optional.of(true) : Optional.empty();
        }

        @JsonCreator
        private DataRow(@JsonProperty(value="columns") Optional<List<?>> columns, @JsonProperty(value="protobufBytes") Optional<byte[]> protobufBytes, @JsonProperty(value="tombstone") Optional<Boolean> tombstone) {
            this.tombstone = tombstone.orElse(false);
            this.columns = columns.map(objects -> Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(objects, "columns"))));
            this.protobufBytes = protobufBytes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataRow row = (DataRow)o;
            return this.tombstone == row.tombstone && Objects.equals(this.columns, row.columns) && Objects.equals(this.protobufBytes, row.protobufBytes);
        }

        public int hashCode() {
            return Objects.hash(this.tombstone, this.columns, this.protobufBytes);
        }
    }

    @Immutable
    public static abstract class BaseRow {
        public String toString() {
            try {
                return OBJECT_MAPPER.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                return super.toString();
            }
        }
    }
}

