/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.k2.kafka.image.publisher;

import io.confluent.k2.kafka.image.publisher.K2TopicsImage;
import io.confluent.k2.kafka.image.publisher.K2TopicsImageAndVersion;
import java.util.Objects;

record DefaultK2TopicsImageAndVersion(K2TopicsImage image, long topicIdToNameVersion, long assignmentsVersion) implements K2TopicsImageAndVersion
{
    static final K2TopicsImageAndVersion EMPTY = new DefaultK2TopicsImageAndVersion(K2TopicsImage.EMPTY, 0L, 0L);

    DefaultK2TopicsImageAndVersion {
        Objects.requireNonNull(image);
        if (assignmentsVersion < topicIdToNameVersion) {
            throw new IllegalArgumentException("Assignments version (" + assignmentsVersion + ") by definition always changes when topic ID to name version (" + topicIdToNameVersion + ") changes and cannot be smaller.");
        }
    }

    @Override
    public K2TopicsImageAndVersion toNextImage(K2TopicsImage newK2TopicsImage) {
        long newTopicIdToNameVersion = newK2TopicsImage.topicIdToName().equals(this.image.topicIdToName()) ? this.topicIdToNameVersion : this.topicIdToNameVersion + 1L;
        long newAssignmentsVersion = newTopicIdToNameVersion > this.topicIdToNameVersion || !newK2TopicsImage.assignmentsEqual(this.image) ? this.assignmentsVersion + 1L : this.assignmentsVersion;
        return new DefaultK2TopicsImageAndVersion(newK2TopicsImage, newTopicIdToNameVersion, newAssignmentsVersion);
    }
}

