/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.trogdor.common.StringExpander;
import org.apache.kafka.trogdor.task.TaskController;
import org.apache.kafka.trogdor.task.TaskSpec;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.workload.ConsumeBenchWorker;
import org.apache.kafka.trogdor.workload.RecordBatchVerifier;
import org.apache.kafka.trogdor.workload.RecordProcessor;

public final class ConsumeBenchSpec
extends TaskSpec {
    private static final String VALID_EXPANDED_TOPIC_NAME_PATTERN = "^[^:]+(:[\\d]+|[^:]*)$";
    private final String consumerNode;
    private final String bootstrapServers;
    private final int targetMessagesPerSec;
    private final long maxMessages;
    private final Map<String, String> consumerConf;
    private final Map<String, String> adminClientConf;
    private final Map<String, String> commonClientConf;
    private final List<String> activeTopics;
    private final String consumerGroup;
    private final int threadsPerWorker;
    private final Optional<RecordBatchVerifier> recordBatchVerifier;
    private final Optional<RecordProcessor> recordProcessor;

    @JsonCreator
    public ConsumeBenchSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="consumerNode") String consumerNode, @JsonProperty(value="bootstrapServers") String bootstrapServers, @JsonProperty(value="targetMessagesPerSec") int targetMessagesPerSec, @JsonProperty(value="maxMessages") long maxMessages, @JsonProperty(value="consumerGroup") String consumerGroup, @JsonProperty(value="consumerConf") Map<String, String> consumerConf, @JsonProperty(value="commonClientConf") Map<String, String> commonClientConf, @JsonProperty(value="adminClientConf") Map<String, String> adminClientConf, @JsonProperty(value="threadsPerWorker") Integer threadsPerWorker, @JsonProperty(value="recordBatchVerifier") Optional<RecordBatchVerifier> recordBatchVerifier, @JsonProperty(value="recordProcessor") Optional<RecordProcessor> recordProcessor, @JsonProperty(value="activeTopics") List<String> activeTopics) {
        super(startMs, durationMs);
        this.consumerNode = consumerNode == null ? "" : consumerNode;
        this.bootstrapServers = bootstrapServers == null ? "" : bootstrapServers;
        this.targetMessagesPerSec = targetMessagesPerSec;
        this.maxMessages = maxMessages;
        this.consumerConf = ConsumeBenchSpec.configOrEmptyMap(consumerConf);
        this.commonClientConf = ConsumeBenchSpec.configOrEmptyMap(commonClientConf);
        this.adminClientConf = ConsumeBenchSpec.configOrEmptyMap(adminClientConf);
        this.activeTopics = activeTopics == null ? new ArrayList() : activeTopics;
        this.consumerGroup = consumerGroup == null ? "" : consumerGroup;
        this.threadsPerWorker = threadsPerWorker == null ? 1 : threadsPerWorker;
        this.recordBatchVerifier = recordBatchVerifier;
        this.recordProcessor = recordProcessor;
    }

    @JsonProperty
    public String consumerNode() {
        return this.consumerNode;
    }

    @JsonProperty
    public String consumerGroup() {
        return this.consumerGroup;
    }

    @JsonProperty
    public String bootstrapServers() {
        return this.bootstrapServers;
    }

    @JsonProperty
    public int targetMessagesPerSec() {
        return this.targetMessagesPerSec;
    }

    @JsonProperty
    public long maxMessages() {
        return this.maxMessages;
    }

    @JsonProperty
    public int threadsPerWorker() {
        return this.threadsPerWorker;
    }

    @JsonProperty
    public Optional<RecordBatchVerifier> recordBatchVerifier() {
        return this.recordBatchVerifier;
    }

    @JsonProperty
    public Optional<RecordProcessor> recordProcessor() {
        return this.recordProcessor;
    }

    @JsonProperty
    public Map<String, String> consumerConf() {
        return this.consumerConf;
    }

    @JsonProperty
    public Map<String, String> commonClientConf() {
        return this.commonClientConf;
    }

    @JsonProperty
    public Map<String, String> adminClientConf() {
        return this.adminClientConf;
    }

    @JsonProperty
    public List<String> activeTopics() {
        return this.activeTopics;
    }

    @Override
    public TaskController newController(String id) {
        return topology -> Collections.singleton(this.consumerNode);
    }

    @Override
    public TaskWorker newTaskWorker(String id) {
        return new ConsumeBenchWorker(id, this);
    }

    Map<String, List<TopicPartition>> materializeTopics() {
        HashMap<String, List<TopicPartition>> partitionsByTopics = new HashMap<String, List<TopicPartition>>();
        for (String rawTopicName : this.activeTopics) {
            Set<String> expandedNames = this.expandTopicName(rawTopicName);
            if (!expandedNames.iterator().next().matches(VALID_EXPANDED_TOPIC_NAME_PATTERN)) {
                throw new IllegalArgumentException(String.format("Expanded topic name %s is invalid", rawTopicName));
            }
            for (String topicName : expandedNames) {
                TopicPartition partition = null;
                if (topicName.contains(":")) {
                    String[] topicAndPartition = topicName.split(":");
                    topicName = topicAndPartition[0];
                    partition = new TopicPartition(topicName, Integer.parseInt(topicAndPartition[1]));
                }
                if (!partitionsByTopics.containsKey(topicName)) {
                    partitionsByTopics.put(topicName, new ArrayList());
                }
                if (partition == null) continue;
                ((List)partitionsByTopics.get(topicName)).add(partition);
            }
        }
        return partitionsByTopics;
    }

    private Set<String> expandTopicName(String topicName) {
        HashSet<String> expandedNames = StringExpander.expand(topicName);
        if (expandedNames.size() == 1) {
            return expandedNames;
        }
        HashSet<String> newNames = new HashSet<String>();
        for (String name : expandedNames) {
            newNames.addAll(this.expandTopicName(name));
        }
        return newNames;
    }
}

