/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.common.WorkerUtils;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.task.WorkerStatusTracker;
import org.apache.kafka.trogdor.workload.MetadataServiceWorkloadSpec;
import org.apache.kafka.trogdor.workload.Throttle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataServiceWorker
implements TaskWorker {
    private static final Logger log = LoggerFactory.getLogger(MetadataServiceWorker.class);
    private static final int THROTTLE_PERIOD_MS = 100;
    private static final String TEST_USER_NAME = "test_username";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Time TIME = Time.SYSTEM;
    private final String id;
    private final MetadataServiceWorkloadSpec spec;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Future<?> statusUpdaterFuture;
    private ExecutorService workerExecutor;
    private ScheduledExecutorService statusUpdaterExecutor;
    private WorkerStatusTracker status;
    private KafkaFutureImpl<String> doneFuture;
    private Platform platform;
    private String clusterId;
    private List<String> activeMetadataServerUrls;
    private long totalAuthorizeCalls;
    private long totalFailedCalls;
    private long startTimeMs;

    public MetadataServiceWorker(String id, MetadataServiceWorkloadSpec spec) {
        this.id = id;
        this.spec = spec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Platform platform, WorkerStatusTracker status, KafkaFutureImpl<String> doneFuture) {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("MetadataServiceWorker is already running.");
        }
        MetadataServiceWorker metadataServiceWorker = this;
        synchronized (metadataServiceWorker) {
            this.totalAuthorizeCalls = 0L;
            this.totalFailedCalls = 0L;
            this.startTimeMs = TIME.milliseconds();
        }
        log.info("{}: Activating MetadataServiceWorker.", (Object)this.id);
        try {
            this.platform = platform;
            this.status = status;
            this.doneFuture = doneFuture;
            this.validateConfigs();
            this.clusterId = this.clusterId();
            status.update((JsonNode)new TextNode("Got clusterId :" + this.clusterId));
            this.createRoleBindings();
            status.update((JsonNode)new TextNode("Created test RoleBindings for clusterId " + this.clusterId));
            this.activeMetadataServerUrls = this.activeMetadataServerUrls();
            status.update((JsonNode)new TextNode("Got active metadata server Urls : " + String.valueOf(this.activeMetadataServerUrls)));
            this.workerExecutor = Executors.newFixedThreadPool(this.activeMetadataServerUrls.size(), ThreadUtils.createThreadFactory((String)"MetadataServiceWorker%d", (boolean)false));
            for (int i = 0; i < this.activeMetadataServerUrls.size(); ++i) {
                this.workerExecutor.submit(new Worker(i));
            }
            this.statusUpdaterExecutor = Executors.newScheduledThreadPool(1, ThreadUtils.createThreadFactory((String)"StatusUpdaterWorkerThread%d", (boolean)false));
            this.statusUpdaterFuture = this.statusUpdaterExecutor.scheduleAtFixedRate(new StatusUpdater(), 30L, 30L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            WorkerUtils.abort(log, "MetadataServiceWorker", e, doneFuture);
        }
    }

    private void validateConfigs() {
        if (this.spec.targetCallsPerSec() <= 0) {
            throw new ConfigException("Can't have targetCallsPerSec <= 0.");
        }
        if (this.spec.numRoleBindings() <= 0) {
            throw new ConfigException("Can't have numRoleBindings <= 0.");
        }
        if (this.spec.adminUserCredentials() == null || this.spec.adminUserCredentials().length() == 0) {
            throw new ConfigException("adminUserCredentials can't be empty.");
        }
        if (this.spec.seedMetadataServerUrl() == null || this.spec.seedMetadataServerUrl().length() == 0) {
            throw new ConfigException("seedMetadataServerUrl can't be empty.");
        }
    }

    private String clusterId() throws Throwable {
        String url = String.format("%s/security/1.0/metadataClusterId", this.spec.seedMetadataServerUrl());
        String[] command = new String[]{"curl", "-sS", "-f", "-X", "GET", "--user", this.spec.adminUserCredentials(), "-H", "Content-Type:application/json", url};
        return this.platform.runCommand(command);
    }

    private void createRoleBindings() throws Throwable {
        Set topicNames = IntStream.range(0, this.spec.numRoleBindings()).mapToObj(i -> "Topic" + i).collect(Collectors.toSet());
        String url = String.format("%s/security/1.0/principals/User:%s/roles/ResourceOwner/bindings", this.spec.seedMetadataServerUrl(), TEST_USER_NAME);
        for (String topic : topicNames) {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            HashMap<String, Map<String, String>> scopeParams = new HashMap<String, Map<String, String>>();
            scopeParams.put("clusters", Collections.singletonMap("kafka-cluster", this.clusterId));
            params.put("scope", scopeParams);
            HashMap<String, String> resourcePatternParams = new HashMap<String, String>();
            resourcePatternParams.put("resourceType", "Topic");
            resourcePatternParams.put("name", topic);
            resourcePatternParams.put("patternType", "LITERAL");
            params.put("resourcePatterns", Collections.singletonList(resourcePatternParams));
            String[] command = new String[]{"curl", "-sS", "-f", "-X", "POST", "--user", this.spec.adminUserCredentials(), "-H", "Content-Type:application/json", "--data", OBJECT_MAPPER.writeValueAsString(params), url};
            this.platform.runCommand(command);
        }
    }

    private List<String> activeMetadataServerUrls() throws Throwable {
        String url = String.format("%s/security/1.0/activenodes/http", this.spec.seedMetadataServerUrl());
        String[] command = new String[]{"curl", "-sS", "-f", "-X", "GET", "--user", this.spec.adminUserCredentials(), "-H", "Content-Type:application/json", url};
        String jsonOutput = this.platform.runCommand(command);
        return (List)OBJECT_MAPPER.readValue(jsonOutput, (TypeReference)new TypeReference<List<String>>(){});
    }

    private String authorize(String url, String topic) throws Throwable {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("userPrincipal", "User:test_username");
        HashMap<String, Object> actionParams = new HashMap<String, Object>();
        HashMap<String, Map<String, String>> scopeParams = new HashMap<String, Map<String, String>>();
        scopeParams.put("clusters", Collections.singletonMap("kafka-cluster", this.clusterId));
        actionParams.put("scope", scopeParams);
        actionParams.put("resourceName", topic);
        actionParams.put("resourceType", "Topic");
        actionParams.put("operation", "Read");
        params.put("actions", Collections.singletonList(actionParams));
        String authorizeUrl = String.format("%s/security/1.0/authorize", url);
        String[] command = new String[]{"curl", "-sS", "-f", "-X", "PUT", "--user", this.spec.adminUserCredentials(), "-H", "Content-Type:application/json", "--data", OBJECT_MAPPER.writeValueAsString(params), authorizeUrl};
        try {
            List results = (List)OBJECT_MAPPER.readValue(this.platform.runCommand(command), (TypeReference)new TypeReference<List<String>>(){});
            return (String)results.get(0);
        }
        catch (IOException e) {
            this.status.update((JsonNode)new TextNode("Error while authorize call : " + e.getMessage()));
            return "UNKNOWN_ERROR";
        }
    }

    @Override
    public void stop(Platform platform) throws Exception {
        if (!this.running.compareAndSet(true, false)) {
            throw new IllegalStateException("MetadataServiceWorker is not running.");
        }
        log.info("{}: Deactivating MetadataServiceWorker.", (Object)this.id);
        this.doneFuture.complete((Object)"");
        this.statusUpdaterFuture.cancel(false);
        this.statusUpdaterExecutor.shutdown();
        this.statusUpdaterExecutor.awaitTermination(1L, TimeUnit.DAYS);
        this.statusUpdaterExecutor = null;
        this.workerExecutor.shutdownNow();
        this.workerExecutor.awaitTermination(1L, TimeUnit.DAYS);
        new StatusUpdater().run();
        this.workerExecutor = null;
        this.doneFuture = null;
        log.info("{}: Deactivated MetadataServiceWorker.", (Object)this.id);
    }

    class Worker
    implements Runnable {
        private final int index;

        Worker(int id) {
            this.index = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            int perPeriod = WorkerUtils.perSecToPerPeriod((float)MetadataServiceWorker.this.spec.targetCallsPerSec() / (float)MetadataServiceWorker.this.activeMetadataServerUrls.size(), 100L);
            Throttle throttle = new Throttle(perPeriod, 100);
            try {
                int totalNumberOfTopics = MetadataServiceWorker.this.spec.numRoleBindings();
                List topicNames = IntStream.range(0, totalNumberOfTopics).mapToObj(i -> "Topic" + i).collect(Collectors.toList());
                int topicIndex = totalNumberOfTopics - 1;
                while (!MetadataServiceWorker.this.doneFuture.isDone()) {
                    throttle.increment();
                    topicIndex = (topicIndex + 1) % totalNumberOfTopics;
                    String result = MetadataServiceWorker.this.authorize(MetadataServiceWorker.this.activeMetadataServerUrls.get(this.index), (String)topicNames.get(topicIndex));
                    boolean success = true;
                    if (!"ALLOWED".equalsIgnoreCase(result)) {
                        success = false;
                    }
                    MetadataServiceWorker metadataServiceWorker = MetadataServiceWorker.this;
                    synchronized (metadataServiceWorker) {
                        ++MetadataServiceWorker.this.totalAuthorizeCalls;
                        if (!success) {
                            ++MetadataServiceWorker.this.totalFailedCalls;
                        }
                    }
                }
                return;
            }
            catch (Throwable e) {
                WorkerUtils.abort(log, "MetadataServiceWorker#Worker", e, MetadataServiceWorker.this.doneFuture);
            }
        }
    }

    private class StatusUpdater
    implements Runnable {
        private StatusUpdater() {
        }

        @Override
        public void run() {
            try {
                long lastTimeMs = Time.SYSTEM.milliseconds();
                JsonNode node = JsonUtil.JSON_SERDE.valueToTree((Object)new StatusData(MetadataServiceWorker.this.totalAuthorizeCalls, MetadataServiceWorker.this.totalFailedCalls, (double)MetadataServiceWorker.this.totalAuthorizeCalls * 1000.0 / (double)(lastTimeMs - MetadataServiceWorker.this.startTimeMs)));
                MetadataServiceWorker.this.status.update(node);
            }
            catch (Exception e) {
                WorkerUtils.abort(log, "StatusUpdater", e, MetadataServiceWorker.this.doneFuture);
            }
        }
    }

    public static class StatusData {
        private final long totalAuthorizeCalls;
        private final long totalFailedCalls;
        private final double callsPerSec;

        @JsonCreator
        StatusData(@JsonProperty(value="totalAuthorizeCalls") long totalAuthorizeCalls, @JsonProperty(value="totalFailedCalls") long totalFailedCalls, @JsonProperty(value="callsPerSec") double callsPerSec) {
            this.totalAuthorizeCalls = totalAuthorizeCalls;
            this.totalFailedCalls = totalFailedCalls;
            this.callsPerSec = callsPerSec;
        }

        @JsonProperty
        public long totalAuthorizeCalls() {
            return this.totalAuthorizeCalls;
        }

        @JsonProperty
        public long totalFailedCalls() {
            return this.totalFailedCalls;
        }

        @JsonProperty
        public double callsPerSec() {
            return this.callsPerSec;
        }
    }
}

