/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.trogdor.workload.RecordBatchVerifier;
import org.apache.kafka.trogdor.workload.SequentialOffsetsVerificationException;

public class SequentialOffsetsRecordBatchVerifier
implements RecordBatchVerifier {
    private final Map<TopicPartition, Long> lastOffsets = new HashMap<TopicPartition, Long>();

    @Override
    public synchronized void verifyRecords(ConsumerRecords<byte[], byte[]> consumerRecords) {
        for (ConsumerRecord record : consumerRecords) {
            TopicPartition topicPartition = new TopicPartition(record.topic(), record.partition());
            if (!this.lastOffsets.containsKey(topicPartition)) {
                this.lastOffsets.put(topicPartition, record.offset());
                continue;
            }
            long lastOffset = this.lastOffsets.get(topicPartition);
            if (lastOffset + 1L != record.offset()) {
                throw new SequentialOffsetsVerificationException(topicPartition, lastOffset + 1L, record.offset());
            }
            this.lastOffsets.put(topicPartition, record.offset());
        }
    }

    @Override
    public synchronized void resetTrackedOffset(TopicPartition topicPartition) {
        this.lastOffsets.remove(topicPartition);
    }

    public synchronized void onPartitionsRevoked(Collection<TopicPartition> partitions) {
        this.lastOffsets.clear();
    }

    public synchronized void onPartitionsAssigned(Collection<TopicPartition> partitions) {
        this.lastOffsets.clear();
    }
}

