/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.trogdor.task.TaskController;
import org.apache.kafka.trogdor.task.TaskSpec;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.workload.PartitionsSpec;
import org.apache.kafka.trogdor.workload.ThroughputGenerator;
import org.apache.kafka.trogdor.workload.TopicStreamWorker;

public final class TopicStreamSpec
extends TaskSpec {
    private final String producerNode;
    private final String bootstrapServers;
    private final ThroughputGenerator throughputGenerator;
    private final Map<String, String> adminClientConf;
    private final Map<String, String> commonClientConf;
    private final String topicPrefix;
    private final PartitionsSpec partitionsSpec;
    private final long topicBatchSize;

    @JsonCreator
    public TopicStreamSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="producerNode") String producerNode, @JsonProperty(value="bootstrapServers") String bootstrapServers, @JsonProperty(value="throughputGenerator") ThroughputGenerator throughputGenerator, @JsonProperty(value="commonClientConf") Map<String, String> commonClientConf, @JsonProperty(value="adminClientConf") Map<String, String> adminClientConf, @JsonProperty(value="topicPrefix") String topicPrefix, @JsonProperty(value="partitionsSpec") PartitionsSpec partitionsSpec, @JsonProperty(value="topicBatchSize") long topicBatchSize) {
        super(startMs, durationMs);
        this.producerNode = producerNode == null ? "" : producerNode;
        this.bootstrapServers = bootstrapServers == null ? "" : bootstrapServers;
        this.throughputGenerator = throughputGenerator;
        this.commonClientConf = TopicStreamSpec.configOrEmptyMap(commonClientConf);
        this.adminClientConf = TopicStreamSpec.configOrEmptyMap(adminClientConf);
        this.topicPrefix = topicPrefix;
        this.partitionsSpec = partitionsSpec;
        this.topicBatchSize = topicBatchSize;
    }

    @JsonProperty
    public String bootstrapServers() {
        return this.bootstrapServers;
    }

    @JsonProperty
    public String producerNode() {
        return this.producerNode;
    }

    @JsonProperty
    public ThroughputGenerator throughputGenerator() {
        return this.throughputGenerator;
    }

    @JsonProperty
    public Map<String, String> commonClientConf() {
        return this.commonClientConf;
    }

    @JsonProperty
    public Map<String, String> adminClientConf() {
        return this.adminClientConf;
    }

    @JsonProperty
    public String topicPrefix() {
        return this.topicPrefix;
    }

    @JsonProperty
    public PartitionsSpec partitionsSpec() {
        return this.partitionsSpec;
    }

    @JsonProperty
    public long topicBatchSize() {
        return this.topicBatchSize;
    }

    @Override
    public TaskController newController(String id) {
        return topology -> Collections.singleton(this.producerNode);
    }

    @Override
    public TaskWorker newTaskWorker(String id) {
        return new TopicStreamWorker(id, this);
    }
}

