/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.common.WorkerUtils;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.task.WorkerStatusTracker;
import org.apache.kafka.trogdor.workload.Histogram;
import org.apache.kafka.trogdor.workload.TopicStreamSpec;
import org.slf4j.LoggerFactory;

public class TopicStreamWorker
implements TaskWorker {
    private final TopicStreamSpec spec;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ScheduledExecutorService executor;
    private WorkerStatusTracker status;
    private KafkaFutureImpl<String> doneFuture;

    public TopicStreamWorker(String id, TopicStreamSpec spec) {
        this.spec = spec;
    }

    @Override
    public void start(Platform platform, WorkerStatusTracker status, KafkaFutureImpl<String> haltFuture) {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("TopicStreamWorker is already running.");
        }
        this.status = status;
        this.doneFuture = haltFuture;
        this.executor = Executors.newScheduledThreadPool(2, ThreadUtils.createThreadFactory((String)"TopicStreamWorkerThread%d", (boolean)false));
        this.executor.submit(new StreamTopics());
    }

    @Override
    public void stop(Platform platform) throws Exception {
        if (!this.running.compareAndSet(true, false)) {
            throw new IllegalStateException("TopicStreamWorker is not running.");
        }
        this.doneFuture.complete((Object)"");
        this.executor.shutdownNow();
        this.executor = null;
        this.status = null;
        this.doneFuture = null;
    }

    public class StreamTopics
    implements Callable<Void> {
        private final Histogram histogram;
        private final Future<?> statusUpdaterFuture;
        private final Admin adminClient;
        private final AtomicLong successfulTopics;
        private final AtomicLong totalSent;

        StreamTopics() {
            this.adminClient = WorkerUtils.createAdminClient(TopicStreamWorker.this.spec.bootstrapServers(), TopicStreamWorker.this.spec.commonClientConf(), TopicStreamWorker.this.spec.adminClientConf());
            this.histogram = new Histogram(60000);
            this.successfulTopics = new AtomicLong();
            this.totalSent = new AtomicLong();
            this.statusUpdaterFuture = TopicStreamWorker.this.executor.scheduleWithFixedDelay(new StatusUpdater(this.histogram, this.successfulTopics, this.totalSent), 5L, 5L, TimeUnit.SECONDS);
        }

        @Override
        public Void call() throws Exception {
            KafkaFuture allTopicFutures = KafkaFuture.completedFuture(null);
            try {
                long batchIdentifier = 0L;
                ArrayList<NewTopic> batch = new ArrayList<NewTopic>();
                while (TopicStreamWorker.this.running.get()) {
                    for (long topicIdentifier = 0L; topicIdentifier < TopicStreamWorker.this.spec.topicBatchSize(); ++topicIdentifier) {
                        String name = String.format("%s-%d-batch_%d", TopicStreamWorker.this.spec.topicPrefix(), topicIdentifier, batchIdentifier);
                        batch.add(TopicStreamWorker.this.spec.partitionsSpec().newTopic(name));
                    }
                    KafkaFuture<Void> newTopicFuture = this.createTopicsRequest(batch);
                    batch.clear();
                    allTopicFutures = KafkaFuture.allOf((KafkaFuture[])new KafkaFuture[]{allTopicFutures, newTopicFuture});
                    TopicStreamWorker.this.spec.throughputGenerator().throttle();
                    ++batchIdentifier;
                }
                allTopicFutures.get(TopicStreamWorker.this.spec.durationMs(), TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.statusUpdaterFuture.cancel(false);
                StatusData statusData = new StatusUpdater(this.histogram, this.successfulTopics, this.totalSent).update();
            }
            TopicStreamWorker.this.doneFuture.complete((Object)"");
            return null;
        }

        public KafkaFuture<Void> createTopicsRequest(Collection<NewTopic> topics) {
            KafkaFuture batchTopicFutures = KafkaFuture.completedFuture(null);
            CreateTopicsCallback callback = new CreateTopicsCallback(this, Instant.now());
            CreateTopicsResult result = this.adminClient.createTopics(topics);
            for (KafkaFuture future : result.values().values()) {
                future.whenComplete(callback::onCompletion);
                batchTopicFutures = KafkaFuture.allOf((KafkaFuture[])new KafkaFuture[]{batchTopicFutures, future});
            }
            return batchTopicFutures;
        }

        void topicDuration(long durationMs) {
            this.histogram.add(durationMs);
        }
    }

    public static class StatusData {
        static final float[] PERCENTILES = new float[]{0.5f, 0.95f, 0.99f};

        @JsonCreator
        StatusData(@JsonProperty(value="totalSent") long totalSent, @JsonProperty(value="averageLatencyMs") float averageLatencyMs, @JsonProperty(value="p50LatencyMs") int p50latencyMs, @JsonProperty(value="p95LatencyMs") int p95latencyMs, @JsonProperty(value="p99LatencyMs") int p99latencyMs, @JsonProperty(value="successfulTopics") long successfulTopics) {
        }
    }

    public class StatusUpdater
    implements Runnable {
        private final Histogram histogram;
        private final AtomicLong successfulTopics;
        private final AtomicLong totalSent;

        StatusUpdater(Histogram histogram, AtomicLong successfulTopics, AtomicLong totalSent) {
            this.histogram = histogram;
            this.successfulTopics = successfulTopics;
            this.totalSent = totalSent;
        }

        @Override
        public void run() {
            try {
                this.update();
            }
            catch (Exception e) {
                WorkerUtils.abort(LoggerFactory.getLogger(TopicStreamWorker.class), "StatusUpdater", e, TopicStreamWorker.this.doneFuture);
            }
        }

        StatusData update() {
            Histogram.Summary summary = this.histogram.summarize(StatusData.PERCENTILES);
            StatusData statusData = new StatusData(this.totalSent.get(), summary.average(), summary.percentiles().get(0).value(), summary.percentiles().get(1).value(), summary.percentiles().get(2).value(), this.successfulTopics.get());
            TopicStreamWorker.this.status.update(JsonUtil.JSON_SERDE.valueToTree((Object)statusData));
            return statusData;
        }
    }

    private static class CreateTopicsCallback {
        private final StreamTopics streamTopics;
        private final Instant start;

        CreateTopicsCallback(StreamTopics streamTopics, Instant start) {
            this.start = start;
            this.streamTopics = streamTopics;
            this.streamTopics.totalSent.getAndIncrement();
        }

        public void onCompletion(Void result, Throwable exception) {
            Duration duration = Duration.between(this.start, Instant.now());
            if (exception != null) {
                throw new RuntimeException(exception);
            }
            this.streamTopics.topicDuration(duration.toMillis());
            this.streamTopics.successfulTopics.getAndIncrement();
        }
    }
}

