/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.trogdor.task.TaskController;
import org.apache.kafka.trogdor.task.TaskSpec;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.workload.ConstantPayloadGenerator;
import org.apache.kafka.trogdor.workload.PayloadGenerator;
import org.apache.kafka.trogdor.workload.SequentialPayloadGenerator;
import org.apache.kafka.trogdor.workload.TransactionBenchWorker;

public class TransactionBenchSpec
extends TaskSpec {
    private final String producerNode;
    private final String bootstrapServers;
    private final int targetTransactionsPerSec;
    private final long maxTransactions;
    private final int messagesPerTransaction;
    private final int offsetsPerTransaction;
    private final int topicsPerTransaction;
    private final int numProducers;
    private final int replicationFactor;
    private final int numPartitionsPerTopic;
    private final PayloadGenerator keyGenerator;
    private final PayloadGenerator valueGenerator;
    private final Map<String, String> producerConf;
    private final Map<String, String> adminClientConf;
    private final Map<String, String> commonClientConf;
    private final String consumerProtocol;

    @JsonCreator
    public TransactionBenchSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="producerNode") String producerNode, @JsonProperty(value="bootstrapServers") String bootstrapServers, @JsonProperty(value="targetTransactionsPerSec") int targetTransactionsPerSec, @JsonProperty(value="maxTransactions") long maxTransactions, @JsonProperty(value="messagesPerTransaction") int messagesPerTransaction, @JsonProperty(value="offsetsPerTransaction") int offsetsPerTransaction, @JsonProperty(value="topicsPerTransaction") int topicsPerTransaction, @JsonProperty(value="replicationFactor") int replicationFactor, @JsonProperty(value="numPartitionsPerTopic") int numPartitionsPerTopic, @JsonProperty(value="numProducers") int numProducers, @JsonProperty(value="keyGenerator") PayloadGenerator keyGenerator, @JsonProperty(value="valueGenerator") PayloadGenerator valueGenerator, @JsonProperty(value="producerConf") Map<String, String> producerConf, @JsonProperty(value="commonClientConf") Map<String, String> commonClientConf, @JsonProperty(value="adminClientConf") Map<String, String> adminClientConf, @JsonProperty(value="consumerProtocol") String consumerProtocol) {
        super(startMs, durationMs);
        this.producerNode = producerNode == null ? "" : producerNode;
        this.bootstrapServers = bootstrapServers == null ? "" : bootstrapServers;
        this.targetTransactionsPerSec = targetTransactionsPerSec;
        this.maxTransactions = maxTransactions;
        this.messagesPerTransaction = messagesPerTransaction;
        this.offsetsPerTransaction = offsetsPerTransaction;
        this.topicsPerTransaction = topicsPerTransaction;
        this.replicationFactor = Math.max(1, replicationFactor);
        this.numPartitionsPerTopic = Math.max(1, numPartitionsPerTopic);
        this.numProducers = Math.max(1, numProducers);
        this.keyGenerator = keyGenerator == null ? new SequentialPayloadGenerator(4, 0L) : keyGenerator;
        this.valueGenerator = valueGenerator == null ? new ConstantPayloadGenerator(512, new byte[0]) : valueGenerator;
        this.producerConf = TransactionBenchSpec.configOrEmptyMap(producerConf);
        this.commonClientConf = TransactionBenchSpec.configOrEmptyMap(commonClientConf);
        this.adminClientConf = TransactionBenchSpec.configOrEmptyMap(adminClientConf);
        this.consumerProtocol = consumerProtocol == null ? "classic" : consumerProtocol;
    }

    @JsonProperty
    public String producerNode() {
        return this.producerNode;
    }

    @JsonProperty
    public String bootstrapServers() {
        return this.bootstrapServers;
    }

    @JsonProperty
    public int targetTransactionsPerSec() {
        return this.targetTransactionsPerSec;
    }

    @JsonProperty
    public long maxTransactions() {
        return this.maxTransactions;
    }

    @JsonProperty
    public int messagesPerTransaction() {
        return this.messagesPerTransaction;
    }

    @JsonProperty
    public int offsetsPerTransaction() {
        return this.offsetsPerTransaction;
    }

    @JsonProperty
    public int topicsPerTransaction() {
        return this.topicsPerTransaction;
    }

    @JsonProperty
    public int replicationFactor() {
        return this.replicationFactor;
    }

    @JsonProperty
    public int numPartitionsPerTopic() {
        return this.numPartitionsPerTopic;
    }

    @JsonProperty
    public int numProducers() {
        return this.numProducers;
    }

    @JsonProperty
    public PayloadGenerator keyGenerator() {
        return this.keyGenerator;
    }

    @JsonProperty
    public PayloadGenerator valueGenerator() {
        return this.valueGenerator;
    }

    @JsonProperty
    public Map<String, String> producerConf() {
        return this.producerConf;
    }

    @JsonProperty
    public Map<String, String> commonClientConf() {
        return this.commonClientConf;
    }

    @JsonProperty
    public Map<String, String> adminClientConf() {
        return this.adminClientConf;
    }

    @JsonProperty
    public String consumerProtocol() {
        return this.consumerProtocol;
    }

    @Override
    public TaskController newController(String id) {
        return topology -> Collections.singleton(this.producerNode);
    }

    @Override
    public TaskWorker newTaskWorker(String id) {
        return new TransactionBenchWorker(id, this);
    }
}

