/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload.partitioner;

import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.trogdor.workload.partitioner.GaussianPartitionerUtils;
import org.apache.kafka.trogdor.workload.partitioner.RandomizedGaussianPartitionerConfig;

public class RandomizedGaussianPartitioner
implements Partitioner {
    private static final long MILLISECONDS_IN_A_MINUTE = 60000L;
    private final Random random = new Random();
    private Time time = Time.SYSTEM;
    private long lastMeanUpdateTime;
    private long meanPeriodMilliseconds;
    private Random meanRandom;
    private int maxMean;
    private int mean;
    private int std;

    public RandomizedGaussianPartitioner() {
    }

    RandomizedGaussianPartitioner(Time time) {
        this.time = time;
    }

    public void configure(Map<String, ?> configs) {
        RandomizedGaussianPartitionerConfig config = new RandomizedGaussianPartitionerConfig(configs);
        this.meanRandom = new Random(config.getInt("confluent.randomized.gaussian.partitioner.mean.generation.seed").intValue());
        this.maxMean = config.getInt("confluent.randomized.gaussian.partitioner.max.mean");
        this.meanPeriodMilliseconds = (long)config.getInt("confluent.randomized.gaussian.partitioner.mean.period.minutes").intValue() * 60000L;
        this.std = config.getInt("confluent.randomized.gaussian.partitioner.std");
        this.randomMean();
    }

    public int partition(String topic, Object key, byte[] keyBytes, Object value, byte[] valueBytes, Cluster cluster) {
        List partitions = cluster.partitionsForTopic(topic);
        return GaussianPartitionerUtils.nextPartition(partitions.size(), this.random, this.std, this.mean());
    }

    void randomMean() {
        this.mean = this.meanRandom.nextInt(this.maxMean);
        this.lastMeanUpdateTime = this.time.hiResClockMs();
    }

    int mean() {
        this.updateMeanIfNeeded();
        return this.mean;
    }

    private void updateMeanIfNeeded() {
        long numFullPeriodsElapsed = (this.time.hiResClockMs() - this.lastMeanUpdateTime) / this.meanPeriodMilliseconds;
        int i = 0;
        while ((long)i < numFullPeriodsElapsed) {
            this.randomMean();
            ++i;
        }
    }

    public void close() {
    }
}

