/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.servlet;

import io.confluent.kafkarest.CeKafkaRestConfig;
import io.confluent.kafkarest.KafkaRestApplication;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.extension.EmbeddedKafkaModule;
import io.confluent.kafkarest.metrics.MultiTenantMetricsDosFilterListener;
import io.confluent.rest.jetty.DoSFilter;
import jakarta.ws.rs.core.Configurable;
import java.util.Map;
import java.util.Properties;

final class EmbeddedKafkaRestApplication
extends KafkaRestApplication {
    private final EmbeddedKafkaModule embeddedKafkaModule;

    EmbeddedKafkaRestApplication(Map<String, Object> configs, String listenerName, EmbeddedKafkaModule embeddedKafkaModule) {
        super(EmbeddedKafkaRestApplication.createKafkaRestConfig(configs), "/kafka", listenerName);
        this.embeddedKafkaModule = embeddedKafkaModule;
        if (this.getMetrics() != null && CeKafkaRestConfig.getBooleanOrDefault((KafkaRestConfig)((KafkaRestConfig)this.getConfiguration()), (String)"metrics.rate.limit.tenant.level.enabled", (boolean)false)) {
            MultiTenantMetricsDosFilterListener dosFilterListener = new MultiTenantMetricsDosFilterListener(this.getMetrics(), this.getMetricsTags(), ((KafkaRestConfig)this.getConfiguration()).getString("metrics.jmx.prefix"));
            this.addGlobalDosfilterListener((DoSFilter.Listener)dosFilterListener);
            this.addNonGlobalDosfilterListener((DoSFilter.Listener)dosFilterListener);
        }
    }

    public void setupResources(Configurable<?> config, KafkaRestConfig appConfig) {
        super.setupResources(config, appConfig);
        config.register((Object)this.embeddedKafkaModule);
    }

    private static KafkaRestConfig createKafkaRestConfig(Map<String, Object> configs) {
        Properties properties = new Properties();
        properties.putAll(configs);
        if (CeKafkaRestConfig.getBooleanOrDefault(configs, (String)"metrics.rate.limit.tenant.level.enabled", (boolean)false)) {
            properties.put("metrics.global.stats.request.tags.enable", "true");
        }
        return new CeKafkaRestConfig(properties);
    }
}

