/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.servlet;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.confluent.http.server.KafkaHttpApplicationProvider;
import io.confluent.http.server.KafkaHttpServerConfig;
import io.confluent.kafka.http.server.KafkaHttpServerInjector;
import io.confluent.kafka.http.server.annotations.InterBrokerListener;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslSecretsStore;
import io.confluent.kafkarest.CeKafkaRestConfig;
import io.confluent.kafkarest.CloudKafkaRestResourceExtension;
import io.confluent.kafkarest.InternalCloudKafkaRestResourceExtension;
import io.confluent.kafkarest.KafkaRestResourceExtension;
import io.confluent.kafkarest.extension.EmbeddedKafkaModule;
import io.confluent.kafkarest.servlet.EmbeddedKafkaRestApplication;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.server.multitenant.MultiTenantSecretsStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafkaRestApplicationProvider
implements KafkaHttpApplicationProvider {
    private static final Logger log = LoggerFactory.getLogger(KafkaRestApplicationProvider.class);
    private static final String CONFIG_PREFIX = "kafka.rest.";
    private static final String CLIENT_CONFIG_PREFIX = "client.";
    private static final String ENABLE_CONFIG = "enable";
    private static final String CONFLUENT_TELEMETRY_PREFIX = "confluent.telemetry.";
    private static final String CONFLUENT_TELEMETRY_EXCLUDE_PREFIX = "confluent.telemetry.exporter._local.";
    private static final String CONFLUENT_TELEMETRY_REPORTER_CLASS = "io.confluent.telemetry.reporter.TelemetryReporter";
    private static final String REST_TELEMETRY_REPORTER_ENABLED = "telemetry.reporter.enabled";
    private static final Boolean REST_TELEMETRY_REPORTER_ENABLED_DEFAULT = false;
    private static final String LISTENER_PREFIX = "listener.name.";
    private static final String EXTERNAL_LISTENER_NAME = "external";

    public List<Application<?>> provideApplications(Map<String, Object> originals, KafkaHttpServerInjector kafkaHttpServerInjector) {
        Map instanceConfig = RestConfig.getInstanceConfig((String)CONFIG_PREFIX, KafkaHttpServerConfig.scoped(originals).getListenerProtocolMap().keySet(), originals);
        String clusterId = ((ClusterResource)kafkaHttpServerInjector.getInstance(ClusterResource.class)).clusterId();
        Endpoint interBrokerListener = (Endpoint)kafkaHttpServerInjector.getInstance(Endpoint.class, InterBrokerListener.class);
        List enabledConfigs = instanceConfig.entrySet().stream().filter(entry -> {
            Boolean enabled = ((Map)entry.getValue()).getOrDefault(ENABLE_CONFIG, true);
            if (enabled instanceof Boolean) {
                return ((Object)enabled).equals(true);
            }
            if (enabled instanceof String) {
                if (((Object)enabled).equals("true")) {
                    return true;
                }
                if (((Object)enabled).equals("false")) {
                    return false;
                }
            }
            throw new ConfigException(String.format("Property %s must be a valid boolean.", ENABLE_CONFIG));
        }).collect(Collectors.toList());
        ArrayList applications = new ArrayList();
        for (Map.Entry entry2 : enabledConfigs) {
            String listenerName = ((String)entry2.getKey()).equals("") ? null : (String)entry2.getKey();
            ImmutableMap<String, Object> conf = KafkaRestApplicationProvider.scoped(listenerName, originals, interBrokerListener, clusterId, (Map)entry2.getValue());
            applications.add((Application<?>)new EmbeddedKafkaRestApplication((Map<String, Object>)conf, listenerName, KafkaRestApplicationProvider.getEmbeddedKafkaModule(kafkaHttpServerInjector)));
        }
        return applications;
    }

    @VisibleForTesting
    static EmbeddedKafkaModule getEmbeddedKafkaModule(KafkaHttpServerInjector injector) {
        MultiTenantSecretsStore secretsStore;
        try {
            secretsStore = (MultiTenantSecretsStore)injector.getInstance(MultiTenantSecretsStore.class);
        }
        catch (KafkaHttpServerInjector.ProvisionException e) {
            log.info("No credentials store injected");
            return new EmbeddedKafkaModule(null);
        }
        if (!(secretsStore instanceof MultiTenantSaslSecretsStore)) {
            log.info("Unexpected credentials store injected: {}", (Object)(secretsStore != null ? secretsStore.getClass().getName() : "null"));
            return new EmbeddedKafkaModule(null);
        }
        log.info("Retrieving injected credentials store");
        return new EmbeddedKafkaModule((MultiTenantSaslSecretsStore)secretsStore);
    }

    static ImmutableMap<String, Object> scoped(String listenerName, Map<String, Object> originals, Endpoint interBrokerListener, String clusterId, Map<String, Object> instanceConfig) {
        boolean bl;
        HashMap<Object, Object> configs = new HashMap<Object, Object>(KafkaHttpServerConfig.scoped(originals).originals());
        KafkaConfig kafkaConfig = new KafkaConfig(originals);
        Map interBrokerClientConfigs = ConfluentConfigs.interBrokerClientConfigs((AbstractConfig)kafkaConfig, (Endpoint)interBrokerListener);
        configs.putAll(KafkaRestApplicationProvider.licenseConfig(interBrokerClientConfigs, originals));
        configs.put("bootstrap.servers", interBrokerClientConfigs.remove("bootstrap.servers"));
        if (kafkaConfig.createNewAuthorizer().isEmpty()) {
            for (Map.Entry<Object, Object> entry : interBrokerClientConfigs.entrySet()) {
                configs.put(CLIENT_CONFIG_PREFIX + (String)entry.getKey(), entry.getValue());
            }
        }
        for (Map.Entry<Object, Object> entry : instanceConfig.entrySet()) {
            configs.put((String)entry.getKey(), entry.getValue());
        }
        Set resourceExtensions = Arrays.stream(configs.getOrDefault("kafka.rest.resource.extension.class", "").toString().split(",")).map(String::trim).filter(ext -> !ext.isEmpty()).collect(Collectors.toSet());
        resourceExtensions.add(KafkaRestResourceExtension.class.getName());
        configs.put("kafka.rest.resource.extension.class", String.join((CharSequence)",", resourceExtensions));
        boolean bl2 = bl = resourceExtensions.contains(CloudKafkaRestResourceExtension.class.getName()) || resourceExtensions.contains(InternalCloudKafkaRestResourceExtension.class.getName());
        if (kafkaConfig.createNewAuthorizer().isEmpty() && !bl) {
            configs.remove("client.metric.reporters");
        }
        configs.put("api.v2.enable", false);
        configs.putAll(KafkaRestApplicationProvider.telemetryReporterConfig(originals, clusterId, bl, instanceConfig));
        configs.remove("listeners");
        configs.remove("listener.protocol.map");
        String bootstrapServers = (String)configs.get("bootstrap.servers");
        String brokerListenerName = bootstrapServers.substring(0, bootstrapServers.indexOf(":")).toLowerCase();
        String listenerProxyProtocolVersionConfig = LISTENER_PREFIX + brokerListenerName + ".confluent.proxy.protocol.version";
        configs.put("proxy.protocol.client.version", originals.getOrDefault(listenerProxyProtocolVersionConfig, CeKafkaRestConfig.PROXY_PROTOCOL_CLIENT_VERSION_DEFAULT));
        configs.put("use.proxy.protocol.with.broker", instanceConfig.getOrDefault("use.proxy.protocol.with.broker", false));
        Object jmxPrefix = "kafka.rest";
        if (listenerName != null && !EXTERNAL_LISTENER_NAME.equalsIgnoreCase(listenerName)) {
            jmxPrefix = (String)jmxPrefix + "." + listenerName;
        }
        configs.put("metrics.jmx.prefix", jmxPrefix);
        return ImmutableMap.copyOf(configs);
    }

    private static String licenseProperty(String suffix) {
        return "confluent.license." + suffix;
    }

    private static Map<String, Object> licenseConfig(Map<String, Object> interBrokerConfigs, Map<String, Object> originals) {
        HashMap<String, Object> licenseConfigs = new HashMap<String, Object>();
        licenseConfigs.put(KafkaRestApplicationProvider.licenseProperty("bootstrap.servers"), interBrokerConfigs.get("bootstrap.servers"));
        for (Map.Entry<String, Object> entry : interBrokerConfigs.entrySet()) {
            licenseConfigs.put(KafkaRestApplicationProvider.licenseProperty(entry.getKey()), entry.getValue());
        }
        licenseConfigs.put(KafkaRestApplicationProvider.licenseProperty("admin.replication.factor"), originals.getOrDefault(KafkaRestApplicationProvider.licenseProperty("topic.replication.factor"), 3));
        return licenseConfigs;
    }

    private static Map<String, Object> telemetryReporterConfig(Map<String, Object> originals, String clusterId, boolean onCloud, Map<String, Object> instanceConfig) {
        HashMap<String, Object> telemetryConfigs = new HashMap<String, Object>();
        if (KafkaRestApplicationProvider.telemetryEnabledForRest(instanceConfig) && onCloud) {
            telemetryConfigs.put("metric.reporters", CONFLUENT_TELEMETRY_REPORTER_CLASS);
            telemetryConfigs.putAll(originals.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(CONFLUENT_TELEMETRY_PREFIX) && !((String)e.getKey()).startsWith(CONFLUENT_TELEMETRY_EXCLUDE_PREFIX)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        } else if (KafkaRestApplicationProvider.enabledForCP(originals) && !onCloud) {
            telemetryConfigs.put("metric.reporters", CONFLUENT_TELEMETRY_REPORTER_CLASS);
            telemetryConfigs.putAll(originals.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(CONFLUENT_TELEMETRY_PREFIX)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            telemetryConfigs.put("metrics.context.resource.cluster.id", clusterId);
            telemetryConfigs.put("metrics.jmx.prefix", "kafka.rest");
        }
        return telemetryConfigs;
    }

    private static boolean enabledForCP(Map<String, Object> originals) {
        Object enabledForCP = originals.getOrDefault("confluent.reporters.telemetry.auto.enable", true);
        if (enabledForCP instanceof String) {
            return "true".equalsIgnoreCase((String)enabledForCP);
        }
        if (enabledForCP instanceof Boolean) {
            return (Boolean)enabledForCP;
        }
        throw new ConfigException(String.format("%s must be a boolean.", "confluent.reporters.telemetry.auto.enable"));
    }

    private static boolean telemetryEnabledForRest(Map<String, Object> instanceConfig) {
        Object enabledForRest = instanceConfig.getOrDefault(REST_TELEMETRY_REPORTER_ENABLED, REST_TELEMETRY_REPORTER_ENABLED_DEFAULT);
        if (enabledForRest instanceof String) {
            return "true".equalsIgnoreCase((String)enabledForRest);
        }
        if (enabledForRest instanceof Boolean) {
            return (Boolean)enabledForRest;
        }
        throw new ConfigException(String.format("%s must be a boolean.", REST_TELEMETRY_REPORTER_ENABLED));
    }
}

