/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import io.confluent.security.auth.store.data.IdentityPoolKey;
import io.confluent.security.auth.store.data.IdentityPoolValue;
import io.confluent.security.auth.store.data.IdentityProviderKey;
import io.confluent.security.auth.store.data.IdentityProviderValue;
import io.confluent.security.auth.store.data.JwtIssuerKey;
import io.confluent.security.auth.store.data.JwtIssuerValue;
import io.confluent.security.trustservice.store.data.IdentityPool;
import io.confluent.security.trustservice.store.data.IdentityProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jose4j.jwk.JsonWebKeySet;

public class TrustCacheUtils {
    private TrustCacheUtils() {
    }

    public static IdentityProviderValue getIdentityProvider(Map<String, IdentityProvider> identityProviders, IdentityProviderKey key) {
        IdentityProvider provider = identityProviders.get(key.providerId());
        return provider == null ? null : new IdentityProviderValue(provider);
    }

    public static IdentityProviderValue updateIdentityProvider(Map<String, IdentityProvider> identityProviders, Map<String, Set<String>> orgToProvidersMapping, IdentityProviderKey key, IdentityProviderValue value) {
        IdentityProvider oldValue = identityProviders.put(key.providerId(), new IdentityProvider(key.orgId(), key.providerId(), value.issuer(), value.jwksEndpoint(), value.subjectClaim()));
        if (!orgToProvidersMapping.containsKey(key.orgId())) {
            ConcurrentHashMap.KeySetView providerIds = ConcurrentHashMap.newKeySet();
            orgToProvidersMapping.put(key.orgId(), providerIds);
        }
        orgToProvidersMapping.get(key.orgId()).add(key.providerId());
        return oldValue == null ? null : new IdentityProviderValue(oldValue);
    }

    public static IdentityProviderValue removeIdentityProvider(Map<String, IdentityProvider> identityProviders, Map<String, Set<String>> orgToProvidersMapping, IdentityProviderKey key) {
        IdentityProvider oldValue = identityProviders.remove(key.providerId());
        ((Set)orgToProvidersMapping.getOrDefault(key.orgId(), new HashSet())).remove(key.providerId());
        if (((Set)orgToProvidersMapping.getOrDefault(key.orgId(), new HashSet())).isEmpty()) {
            orgToProvidersMapping.remove(key.orgId());
        }
        return oldValue == null ? null : new IdentityProviderValue(oldValue);
    }

    public static IdentityPoolValue getIdentityPool(Map<String, IdentityPool> identityPools, IdentityPoolKey identityPoolKey) {
        IdentityPool identityPool = identityPools.get(identityPoolKey.poolId());
        return identityPool == null ? null : new IdentityPoolValue(identityPool);
    }

    public static IdentityPoolValue updateIdentityPool(Map<String, IdentityPool> identityPools, Map<String, Set<String>> providerToPoolsMapping, IdentityPoolKey key, IdentityPoolValue value) {
        IdentityPool oldValue = identityPools.put(key.poolId(), new IdentityPool(key.poolId(), value.version(), value.providerId(), value.issuer(), value.jwksEndpoint(), value.subjectClaim(), value.serviceAccount(), value.policy(), value.orgId()));
        if (!providerToPoolsMapping.containsKey(value.providerId())) {
            ConcurrentHashMap.KeySetView poolIds = ConcurrentHashMap.newKeySet();
            providerToPoolsMapping.put(value.providerId(), poolIds);
        }
        providerToPoolsMapping.get(value.providerId()).add(key.poolId());
        return oldValue == null ? null : new IdentityPoolValue(oldValue);
    }

    public static IdentityPoolValue removeIdentityPool(Map<String, IdentityPool> identityPools, Map<String, Set<String>> providerToPoolsMapping, IdentityPoolKey key) {
        IdentityPool oldIdentityPool = identityPools.remove(key.poolId());
        if (oldIdentityPool == null) {
            return null;
        }
        ((Set)providerToPoolsMapping.getOrDefault(oldIdentityPool.providerId(), new HashSet())).remove(key.poolId());
        if (((Set)providerToPoolsMapping.getOrDefault(oldIdentityPool.providerId(), new HashSet())).isEmpty()) {
            providerToPoolsMapping.remove(oldIdentityPool.providerId());
        }
        return new IdentityPoolValue(oldIdentityPool);
    }

    public static JwtIssuerValue getJwtIssuer(Map<String, JsonWebKeySet> jsonWebKeys, JwtIssuerKey key) {
        JsonWebKeySet jwks = jsonWebKeys.get(key.cacheKey(JwtIssuerKey.Version.V2));
        return jwks == null ? null : new JwtIssuerValue(jwks);
    }

    public static JwtIssuerValue updateJwtIssuer(Map<String, JsonWebKeySet> jsonWebKeys, JwtIssuerKey key, JwtIssuerValue value) {
        JsonWebKeySet oldValue = jsonWebKeys.put(key.cacheKey(JwtIssuerKey.Version.V2), value.keys());
        return oldValue == null ? null : new JwtIssuerValue(oldValue);
    }

    public static JwtIssuerValue removeJwtIssuer(Map<String, JsonWebKeySet> jsonWebKeys, JwtIssuerKey key) {
        JsonWebKeySet oldJwks = jsonWebKeys.remove(key.cacheKey(JwtIssuerKey.Version.V2));
        return oldJwks == null ? null : new JwtIssuerValue(oldJwks);
    }

    public static Collection<IdentityPool> findIdentityPools(Map<String, IdentityPool> identityPools, Map<String, Set<String>> providerToPoolsMapping, String providerId) {
        if (providerId == null || providerId.isEmpty()) {
            throw new IllegalArgumentException("providerId must not be null or empty");
        }
        Set<String> identityPoolIds = providerToPoolsMapping.get(providerId);
        if (identityPoolIds != null && !identityPoolIds.isEmpty()) {
            return identityPoolIds.stream().map(identityPools::get).collect(Collectors.toUnmodifiableList());
        }
        return Collections.emptyList();
    }

    public static Collection<String> findIdentityProviderIds(Map<String, Set<String>> orgToProvidersMapping, String organizationId) {
        if (organizationId == null || organizationId.isEmpty()) {
            throw new IllegalArgumentException("organizationId must not be null or empty");
        }
        Set<String> identityProviderIds = orgToProvidersMapping.get(organizationId);
        if (identityProviderIds != null && !identityProviderIds.isEmpty()) {
            return identityProviderIds.stream().collect(Collectors.toUnmodifiableList());
        }
        return Collections.emptyList();
    }
}

