/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.generated;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ShareGroupStatePartitionMetadataValue
implements ApiMessage {
    List<TopicPartitionsInfo> initializedTopics;
    List<TopicInfo> deletingTopics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("initialized_topics", (Type)new CompactArrayOf((Type)TopicPartitionsInfo.SCHEMA_0), "The topics with initialized share-group state."), new Field("deleting_topics", (Type)new CompactArrayOf((Type)TopicInfo.SCHEMA_0), "The topics whose share-group state is being deleted."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public ShareGroupStatePartitionMetadataValue(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public ShareGroupStatePartitionMetadataValue(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ShareGroupStatePartitionMetadataValue() {
        this.initializedTopics = new ArrayList<TopicPartitionsInfo>(0);
        this.deletingTopics = new ArrayList<TopicInfo>(0);
    }

    public short apiKey() {
        return 15;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public final void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field initializedTopics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<TopicPartitionsInfo> newCollection = new ArrayList<TopicPartitionsInfo>(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(new TopicPartitionsInfo(_readable, _version, _context));
        }
        this.initializedTopics = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field deletingTopics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add((TopicPartitionsInfo)((Object)new TopicInfo(_readable, _version, _context)));
        }
        this.deletingTopics = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeUnsignedVarint(this.initializedTopics.size() + 1);
        for (TopicPartitionsInfo initializedTopicsElement : this.initializedTopics) {
            initializedTopicsElement.write(_writable, _cache, _version, _context);
        }
        _writable.writeUnsignedVarint(this.deletingTopics.size() + 1);
        for (TopicInfo deletingTopicsElement : this.deletingTopics) {
            deletingTopicsElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.initializedTopics.size() + 1)));
        for (TopicPartitionsInfo initializedTopicsElement : this.initializedTopics) {
            initializedTopicsElement.addSize(_size, _cache, _version, _context);
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.deletingTopics.size() + 1)));
        for (TopicInfo deletingTopicsElement : this.deletingTopics) {
            deletingTopicsElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShareGroupStatePartitionMetadataValue)) {
            return false;
        }
        ShareGroupStatePartitionMetadataValue other = (ShareGroupStatePartitionMetadataValue)obj;
        if (this.initializedTopics == null ? other.initializedTopics != null : !this.initializedTopics.equals(other.initializedTopics)) {
            return false;
        }
        if (this.deletingTopics == null ? other.deletingTopics != null : !this.deletingTopics.equals(other.deletingTopics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.initializedTopics == null ? 0 : this.initializedTopics.hashCode());
        hashCode = 31 * hashCode + (this.deletingTopics == null ? 0 : this.deletingTopics.hashCode());
        return hashCode;
    }

    public ShareGroupStatePartitionMetadataValue duplicate() {
        ShareGroupStatePartitionMetadataValue _duplicate = new ShareGroupStatePartitionMetadataValue();
        ArrayList<TopicPartitionsInfo> newInitializedTopics = new ArrayList<TopicPartitionsInfo>(this.initializedTopics.size());
        for (TopicPartitionsInfo _element : this.initializedTopics) {
            newInitializedTopics.add(_element.duplicate());
        }
        _duplicate.initializedTopics = newInitializedTopics;
        ArrayList<TopicInfo> newDeletingTopics = new ArrayList<TopicInfo>(this.deletingTopics.size());
        for (TopicInfo _element : this.deletingTopics) {
            newDeletingTopics.add(_element.duplicate());
        }
        _duplicate.deletingTopics = newDeletingTopics;
        return _duplicate;
    }

    public String toString() {
        return "ShareGroupStatePartitionMetadataValue(initializedTopics=" + MessageUtil.deepToString(this.initializedTopics.iterator()) + ", deletingTopics=" + MessageUtil.deepToString(this.deletingTopics.iterator()) + ")";
    }

    public List<TopicPartitionsInfo> initializedTopics() {
        return this.initializedTopics;
    }

    public List<TopicInfo> deletingTopics() {
        return this.deletingTopics;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ShareGroupStatePartitionMetadataValue setInitializedTopics(List<TopicPartitionsInfo> v) {
        this.initializedTopics = v;
        return this;
    }

    public ShareGroupStatePartitionMetadataValue setDeletingTopics(List<TopicInfo> v) {
        this.deletingTopics = v;
        return this;
    }

    public static class TopicPartitionsInfo
    implements Message {
        Uuid topicId;
        String topicName;
        List<Integer> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("topic_id", (Type)Type.UUID, "The topic identifier."), new Field("topic_name", (Type)Type.COMPACT_STRING, "The topic name."), new Field("partitions", (Type)new CompactArrayOf((Type)Type.INT32), "The partitions."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TopicPartitionsInfo(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TopicPartitionsInfo() {
            this.topicId = Uuid.ZERO_UUID;
            this.topicName = "";
            this.partitions = new ArrayList<Integer>(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        public final void read(Readable _readable, short _version, MessageContext _context) {
            this.topicId = _readable.readUuid();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topicName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topicName had invalid length " + length);
            }
            this.topicName = _readable.readString(length);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeUuid(this.topicId);
            Object _stringBytes = _cache.getSerializedValue((Object)this.topicName);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionsElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionsElement.intValue());
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _size.addBytes(16);
            byte[] _stringBytes = this.topicName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topicName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.topicName, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.partitions.size() + 1)));
            _size.addBytes(this.partitions.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicPartitionsInfo)) {
                return false;
            }
            TopicPartitionsInfo other = (TopicPartitionsInfo)obj;
            if (!this.topicId.equals((Object)other.topicId)) {
                return false;
            }
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.topicId.hashCode();
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public TopicPartitionsInfo duplicate() {
            TopicPartitionsInfo _duplicate = new TopicPartitionsInfo();
            _duplicate.topicId = this.topicId;
            _duplicate.topicName = this.topicName;
            ArrayList<Integer> newPartitions = new ArrayList<Integer>(this.partitions.size());
            for (Integer _element : this.partitions) {
                newPartitions.add(_element);
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TopicPartitionsInfo(topicId=" + this.topicId.toString() + ", topicName=" + (String)(this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public String topicName() {
            return this.topicName;
        }

        public List<Integer> partitions() {
            return this.partitions;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicPartitionsInfo setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public TopicPartitionsInfo setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public TopicPartitionsInfo setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }
    }

    public static class TopicInfo
    implements Message {
        Uuid topicId;
        String topicName;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("topic_id", (Type)Type.UUID, "The topic identifier."), new Field("topic_name", (Type)Type.COMPACT_STRING, "The topic name."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TopicInfo(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TopicInfo() {
            this.topicId = Uuid.ZERO_UUID;
            this.topicName = "";
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        public final void read(Readable _readable, short _version, MessageContext _context) {
            this.topicId = _readable.readUuid();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topicName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topicName had invalid length " + length);
            }
            this.topicName = _readable.readString(length);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeUuid(this.topicId);
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.topicName);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _size.addBytes(16);
            byte[] _stringBytes = this.topicName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topicName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.topicName, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicInfo)) {
                return false;
            }
            TopicInfo other = (TopicInfo)obj;
            if (!this.topicId.equals((Object)other.topicId)) {
                return false;
            }
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.topicId.hashCode();
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            return hashCode;
        }

        public TopicInfo duplicate() {
            TopicInfo _duplicate = new TopicInfo();
            _duplicate.topicId = this.topicId;
            _duplicate.topicName = this.topicName;
            return _duplicate;
        }

        public String toString() {
            return "TopicInfo(topicId=" + this.topicId.toString() + ", topicName=" + (String)(this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ")";
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public String topicName() {
            return this.topicName;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicInfo setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public TopicInfo setTopicName(String v) {
            this.topicName = v;
            return this;
        }
    }
}

