/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.provider;

import io.spiffe.exception.SocketEndpointAddressException;
import io.spiffe.exception.X509SourceException;
import io.spiffe.provider.SpiffeKeyManager;
import io.spiffe.provider.X509SourceManager;
import io.spiffe.provider.exception.SpiffeProviderException;
import io.spiffe.svid.x509svid.X509SvidSource;
import io.spiffe.workloadapi.X509Source;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import lombok.NonNull;

public final class SpiffeKeyManagerFactory
extends KeyManagerFactorySpi {
    @Override
    protected KeyManager[] engineGetKeyManagers() {
        X509Source x509Source = this.getX509Source();
        SpiffeKeyManager spiffeKeyManager = new SpiffeKeyManager((X509SvidSource)x509Source);
        return new KeyManager[]{spiffeKeyManager};
    }

    public KeyManager[] engineGetKeyManagers(@NonNull X509SvidSource x509SvidSource) {
        if (x509SvidSource == null) {
            throw new NullPointerException("x509SvidSource is marked non-null but is null");
        }
        SpiffeKeyManager spiffeKeyManager = new SpiffeKeyManager(x509SvidSource);
        return new KeyManager[]{spiffeKeyManager};
    }

    @Override
    protected void engineInit(KeyStore keyStore, char[] chars) {
    }

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) {
    }

    private X509Source getX509Source() {
        try {
            return X509SourceManager.getX509Source();
        }
        catch (X509SourceException e) {
            throw new SpiffeProviderException("The X.509 source could not be created", e);
        }
        catch (SocketEndpointAddressException e) {
            throw new SpiffeProviderException("The Workload API Socket endpoint address configured is not valid", e);
        }
    }
}

