/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.maybe;

import io.confluent.shaded.io.reactivex.MaybeObserver;
import io.confluent.shaded.io.reactivex.MaybeSource;
import io.confluent.shaded.io.reactivex.Single;
import io.confluent.shaded.io.reactivex.SingleObserver;
import io.confluent.shaded.io.reactivex.SingleSource;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.functions.Function;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableHelper;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeFlatMapSingle<T, R>
extends Single<R> {
    final MaybeSource<T> source;
    final Function<? super T, ? extends SingleSource<? extends R>> mapper;

    public MaybeFlatMapSingle(MaybeSource<T> source, Function<? super T, ? extends SingleSource<? extends R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super R> downstream) {
        this.source.subscribe(new FlatMapMaybeObserver<T, R>(downstream, this.mapper));
    }

    static final class FlatMapSingleObserver<R>
    implements SingleObserver<R> {
        final AtomicReference<Disposable> parent;
        final SingleObserver<? super R> downstream;

        FlatMapSingleObserver(AtomicReference<Disposable> parent, SingleObserver<? super R> downstream) {
            this.parent = parent;
            this.downstream = downstream;
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.replace(this.parent, d);
        }

        @Override
        public void onSuccess(R value) {
            this.downstream.onSuccess(value);
        }

        @Override
        public void onError(Throwable e) {
            this.downstream.onError(e);
        }
    }

    static final class FlatMapMaybeObserver<T, R>
    extends AtomicReference<Disposable>
    implements MaybeObserver<T>,
    Disposable {
        private static final long serialVersionUID = 4827726964688405508L;
        final SingleObserver<? super R> downstream;
        final Function<? super T, ? extends SingleSource<? extends R>> mapper;

        FlatMapMaybeObserver(SingleObserver<? super R> actual, Function<? super T, ? extends SingleSource<? extends R>> mapper) {
            this.downstream = actual;
            this.mapper = mapper;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.setOnce(this, d)) {
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            SingleSource<R> ss;
            try {
                ss = ObjectHelper.requireNonNull(this.mapper.apply(value), "The mapper returned a null SingleSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.onError(ex);
                return;
            }
            if (!this.isDisposed()) {
                ss.subscribe(new FlatMapSingleObserver<R>(this, this.downstream));
            }
        }

        @Override
        public void onError(Throwable e) {
            this.downstream.onError(e);
        }

        @Override
        public void onComplete() {
            this.downstream.onError(new NoSuchElementException());
        }
    }
}

