/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.observable;

import io.confluent.shaded.io.reactivex.ObservableSource;
import io.confluent.shaded.io.reactivex.Observer;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.internal.disposables.ArrayCompositeDisposable;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableHelper;
import io.confluent.shaded.io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.confluent.shaded.io.reactivex.observers.SerializedObserver;

public final class ObservableSkipUntil<T, U>
extends AbstractObservableWithUpstream<T, T> {
    final ObservableSource<U> other;

    public ObservableSkipUntil(ObservableSource<T> source, ObservableSource<U> other) {
        super(source);
        this.other = other;
    }

    @Override
    public void subscribeActual(Observer<? super T> child) {
        SerializedObserver<T> serial = new SerializedObserver<T>(child);
        ArrayCompositeDisposable frc = new ArrayCompositeDisposable(2);
        serial.onSubscribe(frc);
        SkipUntilObserver<? super T> sus = new SkipUntilObserver<T>(serial, frc);
        this.other.subscribe(new SkipUntil(frc, sus, serial));
        this.source.subscribe(sus);
    }

    final class SkipUntil
    implements Observer<U> {
        final ArrayCompositeDisposable frc;
        final SkipUntilObserver<T> sus;
        final SerializedObserver<T> serial;
        Disposable upstream;

        SkipUntil(ArrayCompositeDisposable frc, SkipUntilObserver<T> sus, SerializedObserver<T> serial) {
            this.frc = frc;
            this.sus = sus;
            this.serial = serial;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.frc.setResource(1, d);
            }
        }

        @Override
        public void onNext(U t) {
            this.upstream.dispose();
            this.sus.notSkipping = true;
        }

        @Override
        public void onError(Throwable t) {
            this.frc.dispose();
            this.serial.onError(t);
        }

        @Override
        public void onComplete() {
            this.sus.notSkipping = true;
        }
    }

    static final class SkipUntilObserver<T>
    implements Observer<T> {
        final Observer<? super T> downstream;
        final ArrayCompositeDisposable frc;
        Disposable upstream;
        volatile boolean notSkipping;
        boolean notSkippingLocal;

        SkipUntilObserver(Observer<? super T> actual, ArrayCompositeDisposable frc) {
            this.downstream = actual;
            this.frc = frc;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.frc.setResource(0, d);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.notSkippingLocal) {
                this.downstream.onNext(t);
            } else if (this.notSkipping) {
                this.notSkippingLocal = true;
                this.downstream.onNext(t);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.frc.dispose();
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            this.frc.dispose();
            this.downstream.onComplete();
        }
    }
}

