/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.single;

import io.confluent.shaded.io.reactivex.Single;
import io.confluent.shaded.io.reactivex.SingleObserver;
import io.confluent.shaded.io.reactivex.SingleSource;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.functions.Consumer;

public final class SingleDoOnSuccess<T>
extends Single<T> {
    final SingleSource<T> source;
    final Consumer<? super T> onSuccess;

    public SingleDoOnSuccess(SingleSource<T> source, Consumer<? super T> onSuccess) {
        this.source = source;
        this.onSuccess = onSuccess;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        this.source.subscribe(new DoOnSuccess(observer));
    }

    final class DoOnSuccess
    implements SingleObserver<T> {
        final SingleObserver<? super T> downstream;

        DoOnSuccess(SingleObserver<? super T> observer) {
            this.downstream = observer;
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.downstream.onSubscribe(d);
        }

        @Override
        public void onSuccess(T value) {
            try {
                SingleDoOnSuccess.this.onSuccess.accept(value);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.downstream.onError(ex);
                return;
            }
            this.downstream.onSuccess(value);
        }

        @Override
        public void onError(Throwable e) {
            this.downstream.onError(e);
        }
    }
}

