/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.fetch;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.kafka.common.TopicIdPartition;

public interface PartitionRotateStrategy {
    public LinkedHashMap<TopicIdPartition, Integer> rotate(LinkedHashMap<TopicIdPartition, Integer> var1, PartitionRotateMetadata var2);

    public static PartitionRotateStrategy type(StrategyType type) {
        switch (type.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: 
        }
        return PartitionRotateStrategy::rotateRoundRobin;
    }

    public static LinkedHashMap<TopicIdPartition, Integer> rotateRoundRobin(LinkedHashMap<TopicIdPartition, Integer> topicIdPartitions, PartitionRotateMetadata metadata) {
        if (topicIdPartitions.isEmpty() || topicIdPartitions.size() == 1 || metadata.sessionEpoch < 1) {
            return topicIdPartitions;
        }
        int rotateAt = metadata.sessionEpoch % topicIdPartitions.size();
        if (rotateAt == 0) {
            return topicIdPartitions;
        }
        LinkedHashMap<TopicIdPartition, Integer> suffixPartitions = new LinkedHashMap<TopicIdPartition, Integer>(rotateAt);
        LinkedHashMap<TopicIdPartition, Integer> rotatedPartitions = new LinkedHashMap<TopicIdPartition, Integer>(topicIdPartitions.size());
        int i = 0;
        for (Map.Entry<TopicIdPartition, Integer> entry : topicIdPartitions.entrySet()) {
            if (i < rotateAt) {
                suffixPartitions.put(entry.getKey(), entry.getValue());
            } else {
                rotatedPartitions.put(entry.getKey(), entry.getValue());
            }
            ++i;
        }
        rotatedPartitions.putAll(suffixPartitions);
        return rotatedPartitions;
    }

    public static enum StrategyType {
        ROUND_ROBIN;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }
    }

    public record PartitionRotateMetadata(int sessionEpoch) {
    }
}

