/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.message.DrainCellResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class DrainCellResponse
extends AbstractResponse {
    private final DrainCellResponseData data;

    public DrainCellResponse(DrainCellResponseData data) {
        super(ApiKeys.DRAIN_CELL);
        this.data = data;
    }

    @Override
    public DrainCellResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        DrainCellResponse.updateErrorCounts(counts, Errors.forCode(this.data.errorCode()));
        return counts;
    }

    public boolean hasError() {
        return this.error() != Errors.NONE;
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    public static DrainCellResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new DrainCellResponse(new DrainCellResponseData(new ByteBufferAccessor(buffer), version, context));
    }
}

