/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.checksum.serdes;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class Entry
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_2_0_8();
    }

    public static Entry getRootAsEntry(ByteBuffer _bb) {
        return Entry.getRootAsEntry(_bb, new Entry());
    }

    public static Entry getRootAsEntry(ByteBuffer _bb, Entry obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public Entry __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public String key() {
        int o = this.__offset(4);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer keyAsByteBuffer() {
        return this.__vector_as_bytebuffer(4, 1);
    }

    public ByteBuffer keyInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 4, 1);
    }

    public long checksum() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public long sizeInBytes() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public long lastModifiedMs() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public long entryChecksum() {
        int o = this.__offset(12);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public static int createEntry(FlatBufferBuilder builder, int keyOffset, long checksum, long sizeInBytes, long lastModifiedMs, long entryChecksum) {
        builder.startTable(5);
        Entry.addEntryChecksum(builder, entryChecksum);
        Entry.addLastModifiedMs(builder, lastModifiedMs);
        Entry.addSizeInBytes(builder, sizeInBytes);
        Entry.addChecksum(builder, checksum);
        Entry.addKey(builder, keyOffset);
        return Entry.endEntry(builder);
    }

    public static void startEntry(FlatBufferBuilder builder) {
        builder.startTable(5);
    }

    public static void addKey(FlatBufferBuilder builder, int keyOffset) {
        builder.addOffset(0, keyOffset, 0);
    }

    public static void addChecksum(FlatBufferBuilder builder, long checksum) {
        builder.addLong(1, checksum, 0L);
    }

    public static void addSizeInBytes(FlatBufferBuilder builder, long sizeInBytes) {
        builder.addLong(2, sizeInBytes, 0L);
    }

    public static void addLastModifiedMs(FlatBufferBuilder builder, long lastModifiedMs) {
        builder.addLong(3, lastModifiedMs, 0L);
    }

    public static void addEntryChecksum(FlatBufferBuilder builder, long entryChecksum) {
        builder.addLong(4, entryChecksum, 0L);
    }

    public static int endEntry(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public Entry get(int j) {
            return this.get(new Entry(), j);
        }

        public Entry get(Entry obj, int j) {
            return obj.__assign(Entry.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

