/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.CompletedTxn;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LocalLog;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegments;
import org.apache.kafka.storage.internals.log.ProducerAppendInfo;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.SnapshotFile;
import org.apache.kafka.storage.internals.log.VerificationStateEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergedLogUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MergedLogUtils.class);

    public static void rebuildProducerState(ProducerStateManager producerStateManager, LogSegments segments, long logStartOffset, long lastOffset, Time time, boolean reloadFromCleanShutdown, String logPrefix) throws IOException {
        ArrayList<Optional<Long>> offsetsToSnapshot = new ArrayList<Optional<Long>>();
        if (segments.nonEmpty()) {
            long lastSegmentBaseOffset = segments.lastSegment().get().baseOffset();
            Optional<LogSegment> lowerSegmentOpt = segments.lowerSegment(lastSegmentBaseOffset);
            Optional<Long> nextLatestSegmentBaseOffset = lowerSegmentOpt.map(LogSegment::baseOffset);
            offsetsToSnapshot.add(nextLatestSegmentBaseOffset);
            offsetsToSnapshot.add(Optional.of(lastSegmentBaseOffset));
        }
        offsetsToSnapshot.add(Optional.of(lastOffset));
        LOG.info("{}Loading producer state till offset {}", (Object)logPrefix, (Object)lastOffset);
        if (!producerStateManager.latestSnapshotOffset().isPresent() && reloadFromCleanShutdown) {
            for (Optional optional : offsetsToSnapshot) {
                if (!optional.isPresent()) continue;
                producerStateManager.updateMapEndOffset((Long)optional.get());
                producerStateManager.takeSnapshot();
            }
        } else {
            LOG.info("{}Reloading from producer snapshot and rebuilding producer state from offset {}", (Object)logPrefix, (Object)lastOffset);
            boolean isEmptyBeforeTruncation = producerStateManager.isEmpty() && producerStateManager.mapEndOffset() >= lastOffset;
            long l = time.milliseconds();
            producerStateManager.truncateAndReload(logStartOffset, lastOffset, time.milliseconds());
            long segmentRecoveryStart = time.milliseconds();
            if (lastOffset > producerStateManager.mapEndOffset() && !isEmptyBeforeTruncation) {
                Optional<LogSegment> segmentOfLastOffset = segments.floorSegment(lastOffset);
                for (LogSegment segment : segments.values(producerStateManager.mapEndOffset(), lastOffset)) {
                    FetchDataInfo fetchDataInfo;
                    long startOffset = Utils.max((long)segment.baseOffset(), (long[])new long[]{producerStateManager.mapEndOffset(), logStartOffset});
                    producerStateManager.updateMapEndOffset(startOffset);
                    if (offsetsToSnapshot.contains(Optional.of(segment.baseOffset()))) {
                        producerStateManager.takeSnapshot();
                    }
                    int maxPosition = segment.size();
                    if (segmentOfLastOffset.isPresent() && segmentOfLastOffset.get() == segment) {
                        FileRecords.LogOffsetPosition lop = segment.translateOffset(lastOffset);
                        int n = maxPosition = lop != null ? lop.position : segment.size();
                    }
                    if ((fetchDataInfo = segment.read(startOffset, Integer.MAX_VALUE, maxPosition)) == null) continue;
                    MergedLogUtils.loadProducersFromRecords(producerStateManager, fetchDataInfo.records, segmentRecoveryStart);
                }
            }
            producerStateManager.updateMapEndOffset(lastOffset);
            producerStateManager.takeSnapshot();
            LOG.info("{}Producer state recovery took {}ms for snapshot load and {}ms for segment recovery from offset $lastOffset", new Object[]{logPrefix, segmentRecoveryStart - l, time.milliseconds() - segmentRecoveryStart});
        }
    }

    public static void deleteProducerSnapshots(Collection<LogSegment> segments, ProducerStateManager producerStateManager, boolean asyncDelete, Scheduler scheduler, LogConfig config, LogDirFailureChannel logDirFailureChannel, String parentDir, TopicPartition topicPartition, Optional<E2EChecksumStore> checksumStoreOpt) throws IOException {
        ArrayList snapshotsToDelete = new ArrayList();
        for (LogSegment segment : segments) {
            producerStateManager.removeAndMarkSnapshotForDeletion(segment.baseOffset()).ifPresent(snapshotsToDelete::add);
        }
        Runnable deleteProducerSnapshots = () -> MergedLogUtils.deleteProducerSnapshots(snapshotsToDelete, logDirFailureChannel, parentDir, topicPartition, checksumStoreOpt);
        if (asyncDelete) {
            scheduler.scheduleOnce("delete-producer-snapshot", deleteProducerSnapshots, config.fileDeleteDelayMs);
        } else {
            deleteProducerSnapshots.run();
        }
    }

    private static void deleteProducerSnapshots(List<SnapshotFile> snapshotsToDelete, LogDirFailureChannel logDirFailureChannel, String parentDir, TopicPartition topicPartition, Optional<E2EChecksumStore> checksumStoreOpt) {
        LocalLog.maybeHandleIOException(logDirFailureChannel, parentDir, () -> "Error while deleting producer state snapshots for " + String.valueOf(topicPartition) + " in dir " + parentDir, () -> {
            for (SnapshotFile snapshot : snapshotsToDelete) {
                snapshot.deleteIfExists(checksumStoreOpt);
            }
            return null;
        });
    }

    private static void loadProducersFromRecords(ProducerStateManager producerStateManager, Records records, long currentTimeMs) {
        HashMap loadedProducers = new HashMap();
        ArrayList completedTxns = new ArrayList();
        records.batches().forEach(batch -> {
            if (batch.hasProducerId()) {
                Optional<CompletedTxn> maybeCompletedTxn = MergedLogUtils.updateProducers(producerStateManager, batch, loadedProducers, Optional.empty(), AppendOrigin.REPLICATION, currentTimeMs);
                maybeCompletedTxn.ifPresent(completedTxns::add);
            }
        });
        loadedProducers.values().forEach(producerStateManager::update);
        completedTxns.forEach(producerStateManager::completeTxn);
    }

    public static Optional<CompletedTxn> updateProducers(ProducerStateManager producerStateManager, RecordBatch batch, Map<Long, ProducerAppendInfo> producers, Optional<LogOffsetMetadata> firstOffsetMetadata, AppendOrigin origin, long currentTimeMs) {
        long producerId = batch.producerId();
        producers.putIfAbsent(producerId, producerStateManager.prepareUpdate(producerId, origin, currentTimeMs));
        ProducerAppendInfo appendInfo = producers.get(producerId);
        Optional<CompletedTxn> completedTxn = appendInfo.append(batch, firstOffsetMetadata);
        if (batch.isTransactional()) {
            boolean isV2NextTransactionStarted;
            VerificationStateEntry entry = producerStateManager.verificationStateEntry(producerId);
            boolean bl = isV2NextTransactionStarted = entry != null && entry.supportsEpochBump() && batch.isControlBatch() && batch.producerEpoch() == entry.epoch();
            if (!isV2NextTransactionStarted) {
                producerStateManager.clearVerificationStateEntry(producerId);
            }
        }
        return completedTxn;
    }
}

