/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.image.node.ClusterImageNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.ControllerRegistration;

public final class ClusterImage {
    public static final ClusterImage EMPTY = new ClusterImage(Collections.emptyMap(), Collections.emptyMap());
    private final Map<Integer, BrokerRegistration> brokers;
    private final Map<Integer, ControllerRegistration> controllers;

    public ClusterImage(Map<Integer, BrokerRegistration> brokers, Map<Integer, ControllerRegistration> controllers) {
        this.brokers = Collections.unmodifiableMap(brokers);
        this.controllers = Collections.unmodifiableMap(controllers);
    }

    public boolean isEmpty() {
        return this.brokers.isEmpty();
    }

    public Map<Integer, BrokerRegistration> brokers() {
        return this.brokers;
    }

    public List<Integer> brokerIds() {
        return new ArrayList<Integer>(this.brokers.keySet());
    }

    public BrokerRegistration broker(int nodeId) {
        return this.brokers.get(nodeId);
    }

    public Map<Integer, ControllerRegistration> controllers() {
        return this.controllers;
    }

    public boolean containsBroker(int brokerId) {
        return this.brokers.containsKey(brokerId);
    }

    public long brokerEpoch(int brokerId) {
        BrokerRegistration brokerRegistration = this.broker(brokerId);
        if (brokerRegistration == null) {
            return -1L;
        }
        return brokerRegistration.epoch();
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        for (BrokerRegistration broker : this.brokers.values()) {
            writer.write(broker.toRecord(options));
        }
        if (!this.controllers.isEmpty()) {
            if (!options.metadataVersion().isControllerRegistrationSupported()) {
                options.handleLoss("controller registration data");
            } else {
                for (ControllerRegistration controller : this.controllers.values()) {
                    writer.write(controller.toRecord(options));
                }
            }
        }
    }

    public int hashCode() {
        return Objects.hash(this.brokers, this.controllers);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClusterImage)) {
            return false;
        }
        ClusterImage other = (ClusterImage)o;
        return this.brokers.equals(other.brokers) && this.controllers.equals(other.controllers);
    }

    public String toString() {
        return new ClusterImageNode(this).stringify();
    }
}

