/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.ClearElrRecord;
import org.apache.kafka.common.metadata.MirrorTopicChangeRecord;
import org.apache.kafka.common.metadata.MirrorTopicRecord;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RemoveClusterLinkRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.immutable.ImmutableMap;
import org.apache.kafka.server.immutable.ImmutableSet;

public final class TopicsDelta {
    private final TopicsImage image;
    private final Function<String, String> nameToTenantCallback;
    private final Map<Uuid, TopicDelta> changedTopics = new HashMap<Uuid, TopicDelta>();
    private final Set<Uuid> deletedTopicIds = new HashSet<Uuid>();
    private final Map<String, Uuid> createdTopics = new HashMap<String, Uuid>();

    public TopicsDelta(TopicsImage image, Function<String, String> nameToTenantCallback) {
        this.image = image;
        this.nameToTenantCallback = nameToTenantCallback;
    }

    public TopicsImage image() {
        return this.image;
    }

    public Map<Uuid, TopicDelta> changedTopics() {
        return this.changedTopics;
    }

    public void replay(TopicRecord record) {
        TopicDelta delta = new TopicDelta(new TopicImage(record.name(), record.topicId(), record.topicType(), Collections.emptyMap(), null));
        this.changedTopics.put(record.topicId(), delta);
        this.createdTopics.put(record.name(), record.topicId());
    }

    TopicDelta getOrCreateTopicDelta(Uuid id) {
        TopicDelta topicDelta = this.changedTopics.get(id);
        if (topicDelta == null) {
            topicDelta = new TopicDelta(this.image.getTopic(id));
            this.changedTopics.put(id, topicDelta);
        }
        return topicDelta;
    }

    public void replay(PartitionRecord record) {
        TopicDelta topicDelta = this.getOrCreateTopicDelta(record.topicId());
        topicDelta.replay(record);
    }

    public void replay(PartitionChangeRecord record) {
        TopicDelta topicDelta = this.getOrCreateTopicDelta(record.topicId());
        topicDelta.replay(record);
    }

    private void maybeReplayClearElrRecord(Uuid topicId, ClearElrRecord record) {
        if (!this.deletedTopicIds.contains(topicId)) {
            TopicDelta topicDelta = this.getOrCreateTopicDelta(topicId);
            topicDelta.replay(record);
        }
    }

    public void replay(ClearElrRecord record) {
        if (!record.topicName().isEmpty()) {
            Uuid topicId2 = null;
            if (this.createdTopics.containsKey(record.topicName())) {
                topicId2 = this.createdTopics.get(record.topicName());
            } else if (this.image.getTopic(record.topicName()) != null) {
                topicId2 = this.image.getTopic(record.topicName()).id();
            }
            if (topicId2 == null) {
                throw new RuntimeException("Unable to clear elr for topic with name " + record.topicName() + ": no such topic found.");
            }
            this.maybeReplayClearElrRecord(topicId2, record);
        } else {
            this.image.topicsById().forEach((topicId, image) -> this.maybeReplayClearElrRecord((Uuid)topicId, record));
            this.createdTopicIds().forEach(topicId -> this.maybeReplayClearElrRecord((Uuid)topicId, record));
        }
    }

    public String replay(RemoveTopicRecord record) {
        String topicName;
        TopicDelta topicDelta = this.changedTopics.remove(record.topicId());
        if (topicDelta != null) {
            topicName = topicDelta.image().name();
            if (this.image.topicsById().containsKey((Object)record.topicId())) {
                this.deletedTopicIds.add(record.topicId());
            }
        } else {
            TopicImage topicImage = this.image.getTopic(record.topicId());
            if (topicImage == null) {
                throw new RuntimeException("Unable to delete topic with id " + String.valueOf(record.topicId()) + ": no such topic found.");
            }
            topicName = topicImage.name();
            this.deletedTopicIds.add(record.topicId());
        }
        return topicName;
    }

    public void replay(MirrorTopicRecord record, short version) {
        TopicDelta topicDelta = this.getOrCreateTopicDelta(record.topicId());
        topicDelta.replay(record, version);
    }

    public void replay(MirrorTopicChangeRecord record, short version) {
        TopicDelta topicDelta = this.getOrCreateTopicDelta(record.topicId());
        topicDelta.replay(record, version);
    }

    public void replay(RemoveClusterLinkRecord record) {
        for (Map.Entry<Uuid, TopicDelta> entry : this.changedTopics.entrySet()) {
            TopicDelta topicDelta = entry.getValue();
            if (!topicDelta.latestMirrorTopicState().isPresent() || !topicDelta.latestMirrorTopicState().get().linkId().equals((Object)record.clusterLinkId())) continue;
            topicDelta.replay(record);
        }
        ImmutableMap<Uuid, TopicImage> linkedTopics = this.image.topicsByLinkId(record.clusterLinkId());
        for (Uuid topicId : linkedTopics.keySet()) {
            if (this.deletedTopicIds.contains(topicId) || this.changedTopics.containsKey(topicId)) continue;
            TopicDelta topicDelta = this.getOrCreateTopicDelta(topicId);
            topicDelta.replay(record);
        }
    }

    public void finishSnapshot() {
        for (Uuid topicId : this.image.topicsById().keySet()) {
            if (this.changedTopics.containsKey(topicId)) continue;
            this.deletedTopicIds.add(topicId);
        }
    }

    public void handleMetadataVersionChange(MetadataVersion newVersion) {
    }

    public TopicsImage apply() {
        ImmutableMap newTopicsById = this.image.topicsById();
        ImmutableMap newTopicsByName = this.image.topicsByName();
        ImmutableMap<String, ImmutableSet<String>> newTopicNamesByTenant = this.image.topicNamesByTenant();
        ImmutableMap<Uuid, ImmutableMap<Uuid, TopicImage>> newTopicsByLinkId = this.image.topicsByLinkId();
        for (Uuid uuid : this.deletedTopicIds) {
            String tenant;
            TopicImage originalTopicToBeDeleted = (TopicImage)this.image.topicsById().get((Object)uuid);
            if (originalTopicToBeDeleted == null) {
                throw new IllegalStateException("Missing topic id " + String.valueOf(uuid));
            }
            newTopicsById = newTopicsById.removed((Object)uuid);
            newTopicsByName = newTopicsByName.removed((Object)originalTopicToBeDeleted.name());
            if (originalTopicToBeDeleted.mirrorTopic().isPresent()) {
                Uuid linkId = originalTopicToBeDeleted.mirrorTopic().get().linkId();
                newTopicsByLinkId = TopicsDelta.removeFrom(newTopicsByLinkId, linkId, originalTopicToBeDeleted);
            }
            if ((tenant = this.nameToTenantCallback.apply(originalTopicToBeDeleted.name())) == null) continue;
            newTopicNamesByTenant = TopicsDelta.removeFrom(newTopicNamesByTenant, tenant, originalTopicToBeDeleted);
        }
        for (Map.Entry entry : this.changedTopics.entrySet()) {
            String tenant;
            Optional<MirrorTopic> originalMirrorTopic;
            TopicImage originalTopic;
            Uuid topicId = (Uuid)entry.getKey();
            TopicImage newTopicToBeAddedOrUpdated = ((TopicDelta)entry.getValue()).apply();
            String topicName = newTopicToBeAddedOrUpdated.name();
            newTopicsById = newTopicsById.updated((Object)topicId, (Object)newTopicToBeAddedOrUpdated);
            newTopicsByName = newTopicsByName.updated((Object)topicName, (Object)newTopicToBeAddedOrUpdated);
            Optional<MirrorTopic> newMirrorTopic = newTopicToBeAddedOrUpdated.mirrorTopic();
            if (newMirrorTopic.isPresent()) {
                Uuid linkId = newMirrorTopic.get().linkId();
                newTopicsByLinkId = TopicsDelta.addTo(newTopicsByLinkId, linkId, newTopicToBeAddedOrUpdated);
            }
            if ((originalTopic = (TopicImage)this.image.topicsById().get((Object)topicId)) != null && (originalMirrorTopic = originalTopic.mirrorTopic()).isPresent()) {
                Uuid originalLinkId = originalMirrorTopic.get().linkId();
                if (newMirrorTopic.isPresent() && !newMirrorTopic.get().linkId().equals((Object)originalLinkId)) {
                    throw new IllegalStateException("Mirror topic " + String.valueOf(originalTopic.id()) + "/" + originalTopic.name() + " moved from link " + String.valueOf(originalLinkId) + " to " + String.valueOf(newTopicToBeAddedOrUpdated.id()) + "/" + newTopicToBeAddedOrUpdated.name() + " at link " + String.valueOf(newMirrorTopic.get().linkId()));
                }
                if (!newMirrorTopic.isPresent()) {
                    newTopicsByLinkId = TopicsDelta.removeFrom(newTopicsByLinkId, originalLinkId, originalTopic);
                }
            }
            if ((tenant = this.nameToTenantCallback.apply(topicName)) == null) continue;
            newTopicNamesByTenant = TopicsDelta.addTo(newTopicNamesByTenant, tenant, topicName);
        }
        return new TopicsImage(newTopicsById, newTopicsByName, newTopicNamesByTenant, newTopicsByLinkId);
    }

    public TopicDelta changedTopic(Uuid topicId) {
        return this.changedTopics.get(topicId);
    }

    public boolean topicWasDeleted(String topicName) {
        TopicImage topicImage = this.image.getTopic(topicName);
        if (topicImage == null) {
            return false;
        }
        return this.deletedTopicIds.contains(topicImage.id());
    }

    public Set<Uuid> deletedTopicIds() {
        return this.deletedTopicIds;
    }

    public Collection<Uuid> createdTopicIds() {
        return this.createdTopics.values();
    }

    public LocalReplicaChanges localChanges(int brokerId) {
        HashSet<TopicPartition> deletes = new HashSet<TopicPartition>();
        HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo> electedLeaders = new HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo>();
        HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo> leaders = new HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo>();
        HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo> followers = new HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo>();
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        HashMap<TopicIdPartition, Uuid> directoryIds = new HashMap<TopicIdPartition, Uuid>();
        for (TopicDelta delta : this.changedTopics.values()) {
            LocalReplicaChanges changes = delta.localChanges(brokerId);
            deletes.addAll(changes.deletes());
            electedLeaders.putAll(changes.electedLeaders());
            leaders.putAll(changes.leaders());
            followers.putAll(changes.followers());
            topicIds.putAll(changes.topicIds());
            directoryIds.putAll(changes.directoryIds());
        }
        this.deletedTopicIds().forEach(topicId -> {
            TopicImage topicImage = this.image().getTopic((Uuid)topicId);
            topicImage.partitions().forEach((partitionId, prevPartition) -> {
                if (Replicas.contains(prevPartition.replicas, brokerId)) {
                    deletes.add(new TopicPartition(topicImage.name(), partitionId.intValue()));
                }
            });
        });
        return new LocalReplicaChanges(deletes, electedLeaders, leaders, followers, topicIds, directoryIds);
    }

    public String toString() {
        return "TopicsDelta(changedTopics=" + String.valueOf(this.changedTopics) + ", deletedTopicIds=" + String.valueOf(this.deletedTopicIds) + ", createdTopics=" + String.valueOf(this.createdTopics) + ")";
    }

    static ImmutableMap<Uuid, ImmutableMap<Uuid, TopicImage>> addTo(ImmutableMap<Uuid, ImmutableMap<Uuid, TopicImage>> topicsByLinkId, Uuid linkId, TopicImage newTopicToBeAddedOrUpdated) {
        ImmutableMap currrentTopicsForThisLinkId = (ImmutableMap)topicsByLinkId.getOrDefault((Object)linkId, (Object)ImmutableMap.empty());
        ImmutableMap newTopicsForThisLinkId = currrentTopicsForThisLinkId.updated((Object)newTopicToBeAddedOrUpdated.id(), (Object)newTopicToBeAddedOrUpdated);
        return topicsByLinkId.updated((Object)linkId, (Object)newTopicsForThisLinkId);
    }

    static ImmutableMap<Uuid, ImmutableMap<Uuid, TopicImage>> removeFrom(ImmutableMap<Uuid, ImmutableMap<Uuid, TopicImage>> topicsByLinkId, Uuid linkId, TopicImage topic) {
        ImmutableMap currrentTopicsForLinkId = (ImmutableMap)topicsByLinkId.get((Object)linkId);
        if (currrentTopicsForLinkId == null) {
            throw new IllegalStateException("Missing topics for linkID " + String.valueOf(linkId));
        }
        ImmutableMap newTopicsForLinkId = currrentTopicsForLinkId.removed((Object)topic.id());
        if (newTopicsForLinkId.size() == currrentTopicsForLinkId.size()) {
            throw new IllegalStateException("Missing topic with Uuid " + String.valueOf(topic.id()) + " for linkID " + String.valueOf(linkId));
        }
        if (newTopicsForLinkId.isEmpty()) {
            return topicsByLinkId.removed((Object)linkId);
        }
        return topicsByLinkId.updated((Object)linkId, (Object)newTopicsForLinkId);
    }

    static ImmutableMap<String, ImmutableSet<String>> addTo(ImmutableMap<String, ImmutableSet<String>> topicNamesByTenant, String tenant, String topicName) {
        ImmutableSet currentTopicNamesForTenant = (ImmutableSet)topicNamesByTenant.getOrDefault((Object)tenant, (Object)ImmutableSet.empty());
        ImmutableSet newTopicNamesForTenant = currentTopicNamesForTenant.added((Object)topicName);
        return topicNamesByTenant.updated((Object)tenant, (Object)newTopicNamesForTenant);
    }

    static ImmutableMap<String, ImmutableSet<String>> removeFrom(ImmutableMap<String, ImmutableSet<String>> topicNamesByTenant, String tenant, TopicImage topic) {
        ImmutableSet currentTopicNamesForTenant = (ImmutableSet)topicNamesByTenant.get((Object)tenant);
        if (currentTopicNamesForTenant == null) {
            throw new IllegalStateException("Missing topic with name " + topic.name() + " for tenant " + tenant + " (null)");
        }
        ImmutableSet newTopicNamesForTenant = currentTopicNamesForTenant.removed((Object)topic.name());
        if (newTopicNamesForTenant.size() == currentTopicNamesForTenant.size()) {
            throw new IllegalStateException("Missing topic with name " + topic.name() + " for tenant " + tenant + "(missing)");
        }
        if (newTopicNamesForTenant.isEmpty()) {
            return topicNamesByTenant.removed((Object)tenant);
        }
        return topicNamesByTenant.updated((Object)tenant, (Object)newTopicNamesForTenant);
    }
}

