/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.RegisterControllerRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;

public class ControllerRegistration {
    private final int id;
    private final Uuid incarnationId;
    private final boolean zkMigrationReady;
    private final Map<String, Endpoint> listeners;
    private final Map<String, VersionRange> supportedFeatures;
    private final Set<Uuid> metadataEncryptors;

    private ControllerRegistration(int id, Uuid incarnationId, boolean zkMigrationReady, Map<String, Endpoint> listeners, Map<String, VersionRange> supportedFeatures, Set<Uuid> metadataEncryptors) {
        this.id = id;
        this.incarnationId = incarnationId;
        this.zkMigrationReady = zkMigrationReady;
        this.listeners = listeners;
        this.supportedFeatures = supportedFeatures;
        this.metadataEncryptors = metadataEncryptors;
    }

    public int id() {
        return this.id;
    }

    public Uuid incarnationId() {
        return this.incarnationId;
    }

    public boolean zkMigrationReady() {
        return this.zkMigrationReady;
    }

    public Map<String, Endpoint> listeners() {
        return this.listeners;
    }

    public Optional<Node> node(String listenerName) {
        Endpoint endpoint = this.listeners().get(listenerName);
        if (endpoint == null) {
            return Optional.empty();
        }
        return Optional.of(new Node(this.id, endpoint.host(), endpoint.port(), null));
    }

    public Map<String, VersionRange> supportedFeatures() {
        return this.supportedFeatures;
    }

    public Set<Uuid> metadataEncryptors() {
        return this.metadataEncryptors;
    }

    public ApiMessageAndVersion toRecord(ImageWriterOptions options) {
        RegisterControllerRecord registrationRecord = new RegisterControllerRecord().setControllerId(this.id).setIncarnationId(this.incarnationId).setZkMigrationReady(this.zkMigrationReady);
        for (Map.Entry<String, Endpoint> entry : this.listeners.entrySet()) {
            Endpoint endpoint = entry.getValue();
            registrationRecord.endPoints().add(new RegisterControllerRecord.ControllerEndpoint().setName(entry.getKey()).setHost(endpoint.host()).setPort(endpoint.port()).setSecurityProtocol(endpoint.securityProtocol().id));
        }
        for (Map.Entry<String, Object> entry : this.supportedFeatures.entrySet()) {
            registrationRecord.features().add(new RegisterControllerRecord.ControllerFeature().setName(entry.getKey()).setMinSupportedVersion(((VersionRange)entry.getValue()).min()).setMaxSupportedVersion(((VersionRange)entry.getValue()).max()));
        }
        if (this.metadataEncryptors == null) {
            registrationRecord.setMetadataEncryptors(null);
        } else {
            ArrayList<RegisterControllerRecord.Encryptor> registrationRecordEncryptors = new ArrayList<RegisterControllerRecord.Encryptor>();
            this.metadataEncryptors.forEach(uuid -> registrationRecordEncryptors.add(new RegisterControllerRecord.Encryptor().setEncryptorId((Uuid)uuid)));
            registrationRecordEncryptors.sort(Comparator.comparing(RegisterControllerRecord.Encryptor::encryptorId));
            registrationRecord.setMetadataEncryptors(registrationRecordEncryptors);
        }
        return new ApiMessageAndVersion((ApiMessage)registrationRecord, options.metadataVersion().registerControllerRecordVersion());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.incarnationId, this.zkMigrationReady, this.listeners, this.supportedFeatures, this.metadataEncryptors);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ControllerRegistration)) {
            return false;
        }
        ControllerRegistration other = (ControllerRegistration)o;
        return other.id == this.id && other.incarnationId.equals((Object)this.incarnationId) && other.zkMigrationReady == this.zkMigrationReady && other.listeners.equals(this.listeners) && other.supportedFeatures.equals(this.supportedFeatures) && Objects.equals(other.metadataEncryptors, this.metadataEncryptors);
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("ControllerRegistration(id=").append(this.id);
        bld.append(", incarnationId=").append(this.incarnationId);
        bld.append(", zkMigrationReady=").append(this.zkMigrationReady);
        bld.append(", listeners=[").append(this.listeners.keySet().stream().sorted().map(n -> this.listeners.get(n).toString()).collect(Collectors.joining(", ")));
        bld.append("], supportedFeatures={").append(this.supportedFeatures.keySet().stream().sorted().map(k -> k + ": " + String.valueOf(this.supportedFeatures.get(k))).collect(Collectors.joining(", ")));
        bld.append("}");
        bld.append(", metadataEncryptors=");
        if (this.metadataEncryptors == null) {
            bld.append("null");
        } else {
            bld.append("[");
            bld.append(this.metadataEncryptors.stream().map(Uuid::toString).sorted().collect(Collectors.joining(", ")));
            bld.append("]");
        }
        bld.append(")");
        return bld.toString();
    }

    public static class Builder {
        private int id;
        private Uuid incarnationId;
        private boolean zkMigrationReady;
        private Map<String, Endpoint> listeners;
        private Map<String, VersionRange> supportedFeatures;
        private Set<Uuid> metadataEncryptors = null;

        public Builder() {
            this.id = 0;
            this.incarnationId = null;
            this.zkMigrationReady = false;
            this.listeners = null;
            this.supportedFeatures = null;
            this.metadataEncryptors = null;
        }

        public Builder(RegisterControllerRecord record) {
            this.id = record.controllerId();
            this.incarnationId = record.incarnationId();
            this.zkMigrationReady = record.zkMigrationReady();
            HashMap newListeners = new HashMap();
            record.endPoints().forEach(endPoint -> {
                SecurityProtocol protocol = SecurityProtocol.forId((short)endPoint.securityProtocol());
                if (protocol == null) {
                    throw new RuntimeException("Unknown security protocol " + endPoint.securityProtocol());
                }
                newListeners.put(endPoint.name(), new Endpoint(endPoint.name(), protocol, endPoint.host(), endPoint.port()));
            });
            this.listeners = Collections.unmodifiableMap(newListeners);
            HashMap newSupportedFeatures = new HashMap();
            record.features().forEach(feature -> newSupportedFeatures.put(feature.name(), VersionRange.of(feature.minSupportedVersion(), feature.maxSupportedVersion())));
            this.supportedFeatures = Collections.unmodifiableMap(newSupportedFeatures);
            if (record.metadataEncryptors() != null) {
                this.metadataEncryptors = new HashSet<Uuid>();
                record.metadataEncryptors().forEach(e -> this.metadataEncryptors.add(e.encryptorId()));
            }
        }

        public Builder setId(int id) {
            this.id = id;
            return this;
        }

        public Builder setIncarnationId(Uuid incarnationId) {
            this.incarnationId = incarnationId;
            return this;
        }

        public Builder setZkMigrationReady(boolean zkMigrationReady) {
            this.zkMigrationReady = zkMigrationReady;
            return this;
        }

        public Builder setListeners(Map<String, Endpoint> listeners) {
            this.listeners = listeners;
            return this;
        }

        public Builder setSupportedFeatures(Map<String, VersionRange> supportedFeatures) {
            this.supportedFeatures = supportedFeatures;
            return this;
        }

        public Builder setMetadataEncryptors(Set<Uuid> metadataEncryptors) {
            this.metadataEncryptors = metadataEncryptors;
            return this;
        }

        public ControllerRegistration build() {
            if (this.incarnationId == null) {
                throw new RuntimeException("You must set incarnationId.");
            }
            if (this.listeners == null) {
                throw new RuntimeException("You must set listeners.");
            }
            if (this.supportedFeatures == null) {
                this.supportedFeatures = new HashMap<String, VersionRange>();
                this.supportedFeatures.put("confluent.metadata.version", VersionRange.of(MetadataVersion.MINIMUM_VERSION.confluentFeatureLevel(), MetadataVersion.latestProduction().confluentFeatureLevel()));
            }
            return new ControllerRegistration(this.id, this.incarnationId, this.zkMigrationReady, this.listeners, this.supportedFeatures, this.metadataEncryptors);
        }
    }
}

