/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.confluent.flink.apiserver.client.JSON;
import io.confluent.flink.apiserver.client.model.ApisMetaV1ObjectMeta;
import io.confluent.flink.apiserver.client.model.FlinkV1ArtifactSpec;
import io.confluent.flink.apiserver.client.model.FlinkV1ArtifactStatus;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FlinkV1Artifact
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_CELL = "cell";
    @SerializedName(value="cell")
    private String cell = "";
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private ApisMetaV1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_SPEC = "spec";
    @SerializedName(value="spec")
    private FlinkV1ArtifactSpec spec;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private FlinkV1ArtifactStatus status;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public FlinkV1Artifact apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public FlinkV1Artifact cell(String cell) {
        this.cell = cell;
        return this;
    }

    @Nonnull
    public String getCell() {
        return this.cell;
    }

    public void setCell(String cell) {
        this.cell = cell;
    }

    public FlinkV1Artifact kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public FlinkV1Artifact metadata(ApisMetaV1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nonnull
    public ApisMetaV1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ApisMetaV1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public FlinkV1Artifact spec(FlinkV1ArtifactSpec spec) {
        this.spec = spec;
        return this;
    }

    @Nonnull
    public FlinkV1ArtifactSpec getSpec() {
        return this.spec;
    }

    public void setSpec(FlinkV1ArtifactSpec spec) {
        this.spec = spec;
    }

    public FlinkV1Artifact status(FlinkV1ArtifactStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    public FlinkV1ArtifactStatus getStatus() {
        return this.status;
    }

    public void setStatus(FlinkV1ArtifactStatus status) {
        this.status = status;
    }

    public FlinkV1Artifact putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlinkV1Artifact flinkV1Artifact = (FlinkV1Artifact)o;
        return Objects.equals(this.apiVersion, flinkV1Artifact.apiVersion) && Objects.equals(this.cell, flinkV1Artifact.cell) && Objects.equals(this.kind, flinkV1Artifact.kind) && Objects.equals(this.metadata, flinkV1Artifact.metadata) && Objects.equals(this.spec, flinkV1Artifact.spec) && Objects.equals(this.status, flinkV1Artifact.status) && Objects.equals(this.additionalProperties, flinkV1Artifact.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.cell, this.kind, this.metadata, this.spec, this.status, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlinkV1Artifact {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    cell: ").append(this.toIndentedString(this.cell)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    spec: ").append(this.toIndentedString(this.spec)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in FlinkV1Artifact is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_API_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_VERSION).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_CELL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cell` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CELL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
    }

    public static FlinkV1Artifact fromJson(String jsonString) throws IOException {
        return (FlinkV1Artifact)JSON.getGson().fromJson(jsonString, FlinkV1Artifact.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_API_VERSION);
        openapiFields.add(SERIALIZED_NAME_CELL);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiFields.add(SERIALIZED_NAME_SPEC);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CELL);
        openapiRequiredFields.add(SERIALIZED_NAME_METADATA);
        openapiRequiredFields.add(SERIALIZED_NAME_SPEC);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!FlinkV1Artifact.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FlinkV1Artifact.class));
            return new TypeAdapter<FlinkV1Artifact>(){

                public void write(JsonWriter out, FlinkV1Artifact value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public FlinkV1Artifact read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    FlinkV1Artifact.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    FlinkV1Artifact instance = (FlinkV1Artifact)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

