/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.test;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.tools.test.SqlTestExecutor;
import io.confluent.ksql.tools.test.command.SqlTestOptions;
import io.confluent.ksql.tools.test.parser.SqlTestLoader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SqlTestingTool {
    private static final Logger LOGGER = LogManager.getLogger(SqlTestingTool.class);

    private SqlTestingTool() {
    }

    public static void main(String[] args) {
        try {
            int code = SqlTestingTool.run(args);
            System.exit(code);
        }
        catch (Exception e) {
            System.exit(1);
        }
    }

    @VisibleForTesting
    static int run(String[] args) throws IOException {
        SqlTestOptions testOptions = SqlTestOptions.parse(args);
        if (testOptions == null) {
            return 1;
        }
        Path tempFolder = Paths.get(testOptions.getTempFolder(), new String[0]);
        SqlTestLoader loader = new SqlTestLoader(Paths.get(testOptions.getTestDirectory(), new String[0]));
        loader.load().forEach(test -> SqlTestingTool.executeTest(test, SqlTestExecutor.create(tempFolder), tempFolder.toFile()));
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeTest(SqlTestLoader.SqlTest test, SqlTestExecutor executor, File tempFolder) {
        try {
            executor.executeTest(test);
            LOGGER.info("\t >>> Test passed!");
        }
        catch (Throwable e) {
            LOGGER.error("\t>>>>> Test failed: " + e.getMessage());
        }
        finally {
            SqlTestingTool.cleanUp(executor, tempFolder);
        }
    }

    private static void cleanUp(SqlTestExecutor executor, File tempFolder) {
        executor.close();
        try {
            FileUtils.cleanDirectory((File)tempFolder);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to clean up temp folder: " + e.getMessage());
        }
    }
}

